/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.text.BreakDictionary;
import com.ibm.icu.text.RuleBasedBreakIterator;
import com.ibm.icu.text.UnicodeSet;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.CharacterIterator;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class DictionaryBasedBreakIterator
extends RuleBasedBreakIterator {
    private BreakDictionary dictionary;
    private boolean[] categoryFlags;
    private int dictionaryCharCount;
    private int[] cachedBreakPositions;
    private int positionInCache;
    private static final String DICTIONARY_VAR = "_dictionary_";

    public DictionaryBasedBreakIterator(String description, InputStream dictionaryStream) throws IOException {
        super(description);
        this.dictionary = new BreakDictionary(dictionaryStream);
    }

    protected RuleBasedBreakIterator.Builder makeBuilder() {
        return new Builder();
    }

    public void writeTablesToFile(FileOutputStream file, boolean littleEndian) throws IOException {
        super.writeTablesToFile(file, littleEndian);
        DataOutputStream out = new DataOutputStream(file);
        this.writeSwappedInt(8, out, littleEndian);
        this.writeSwappedInt((short)(this.categoryFlags.length + 3 & 0xF), out, littleEndian);
        int i = 0;
        while (i < this.categoryFlags.length) {
            out.writeBoolean(this.categoryFlags[i]);
            ++i;
        }
        switch (this.categoryFlags.length % 4) {
            case 1: {
                out.write(0);
            }
            case 2: {
                out.write(0);
            }
            case 3: {
                out.write(0);
            }
        }
    }

    public void setText(CharacterIterator newText) {
        super.setText(newText);
        this.cachedBreakPositions = null;
        this.dictionaryCharCount = 0;
        this.positionInCache = 0;
    }

    public int first() {
        this.cachedBreakPositions = null;
        this.dictionaryCharCount = 0;
        this.positionInCache = 0;
        return super.first();
    }

    public int last() {
        this.cachedBreakPositions = null;
        this.dictionaryCharCount = 0;
        this.positionInCache = 0;
        return super.last();
    }

    public int previous() {
        CharacterIterator text = this.getText();
        if (this.cachedBreakPositions != null && this.positionInCache > 0) {
            --this.positionInCache;
            text.setIndex(this.cachedBreakPositions[this.positionInCache]);
            return this.cachedBreakPositions[this.positionInCache];
        }
        this.cachedBreakPositions = null;
        int result = super.previous();
        if (this.cachedBreakPositions != null) {
            this.positionInCache = this.cachedBreakPositions.length - 2;
        }
        return result;
    }

    public int preceding(int offset) {
        CharacterIterator text = this.getText();
        RuleBasedBreakIterator.checkOffset(offset, text);
        if (this.cachedBreakPositions == null || offset <= this.cachedBreakPositions[0] || offset > this.cachedBreakPositions[this.cachedBreakPositions.length - 1]) {
            this.cachedBreakPositions = null;
            return super.preceding(offset);
        }
        this.positionInCache = 0;
        while (this.positionInCache < this.cachedBreakPositions.length && offset > this.cachedBreakPositions[this.positionInCache]) {
            ++this.positionInCache;
        }
        --this.positionInCache;
        text.setIndex(this.cachedBreakPositions[this.positionInCache]);
        return text.getIndex();
    }

    public int following(int offset) {
        CharacterIterator text = this.getText();
        RuleBasedBreakIterator.checkOffset(offset, text);
        if (this.cachedBreakPositions == null || offset < this.cachedBreakPositions[0] || offset >= this.cachedBreakPositions[this.cachedBreakPositions.length - 1]) {
            this.cachedBreakPositions = null;
            return super.following(offset);
        }
        this.positionInCache = 0;
        while (this.positionInCache < this.cachedBreakPositions.length && offset >= this.cachedBreakPositions[this.positionInCache]) {
            ++this.positionInCache;
        }
        text.setIndex(this.cachedBreakPositions[this.positionInCache]);
        return text.getIndex();
    }

    protected int handleNext() {
        CharacterIterator text = this.getText();
        if (this.cachedBreakPositions == null || this.positionInCache == this.cachedBreakPositions.length - 1) {
            int startPos = text.getIndex();
            this.dictionaryCharCount = 0;
            int result = super.handleNext();
            if (this.dictionaryCharCount > 1 && result - startPos > 1) {
                this.divideUpDictionaryRange(startPos, result);
            } else {
                this.cachedBreakPositions = null;
                return result;
            }
        }
        if (this.cachedBreakPositions != null) {
            ++this.positionInCache;
            text.setIndex(this.cachedBreakPositions[this.positionInCache]);
            return this.cachedBreakPositions[this.positionInCache];
        }
        return -9999;
    }

    protected int lookupCategory(char c) {
        int result = super.lookupCategory(c);
        if (result != -1 && this.categoryFlags[result]) {
            ++this.dictionaryCharCount;
        }
        return result;
    }

    private void divideUpDictionaryRange(int startPos, int endPos) {
        CharacterIterator text = this.getText();
        text.setIndex(startPos);
        char c = text.current();
        int category = this.lookupCategory(c);
        while (category == -1 || !this.categoryFlags[category]) {
            c = text.next();
            category = this.lookupCategory(c);
        }
        Stack currentBreakPositions = new Stack();
        Stack<Integer> possibleBreakPositions = new Stack<Integer>();
        Vector wrongBreakPositions = new Vector();
        int state = 0;
        int farthestEndPoint = text.getIndex();
        Stack bestBreakPositions = null;
        c = text.current();
        while (true) {
            if (this.dictionary.at(state, 0) == -1) {
                possibleBreakPositions.push(new Integer(text.getIndex()));
            }
            if ((state = this.dictionary.at(state, c) & 0xFFFF) == 65535) {
                currentBreakPositions.push(new Integer(text.getIndex()));
                break;
            }
            if (state == 0 || text.getIndex() >= endPos) {
                if (text.getIndex() > farthestEndPoint) {
                    farthestEndPoint = text.getIndex();
                    bestBreakPositions = (Stack)currentBreakPositions.clone();
                }
                while (!possibleBreakPositions.isEmpty() && wrongBreakPositions.contains(possibleBreakPositions.peek())) {
                    possibleBreakPositions.pop();
                }
                if (possibleBreakPositions.isEmpty()) {
                    if (bestBreakPositions != null) {
                        currentBreakPositions = bestBreakPositions;
                        if (farthestEndPoint >= endPos) break;
                        text.setIndex(farthestEndPoint + 1);
                    } else {
                        if ((currentBreakPositions.size() == 0 || ((Integer)currentBreakPositions.peek()).intValue() != text.getIndex()) && text.getIndex() != startPos) {
                            currentBreakPositions.push(new Integer(text.getIndex()));
                        }
                        text.next();
                        currentBreakPositions.push(new Integer(text.getIndex()));
                    }
                } else {
                    Integer temp = (Integer)possibleBreakPositions.pop();
                    Object temp2 = null;
                    while (!currentBreakPositions.isEmpty() && temp < (Integer)currentBreakPositions.peek()) {
                        temp2 = currentBreakPositions.pop();
                        wrongBreakPositions.addElement(temp2);
                    }
                    currentBreakPositions.push(temp);
                    text.setIndex((Integer)currentBreakPositions.peek());
                }
                c = text.current();
                state = 0;
                if (text.getIndex() < endPos) continue;
                break;
            }
            c = text.next();
        }
        if (!currentBreakPositions.isEmpty()) {
            currentBreakPositions.pop();
        }
        currentBreakPositions.push(new Integer(endPos));
        this.cachedBreakPositions = new int[currentBreakPositions.size() + 1];
        this.cachedBreakPositions[0] = startPos;
        int i = 0;
        while (i < currentBreakPositions.size()) {
            this.cachedBreakPositions[i + 1] = (Integer)currentBreakPositions.elementAt(i);
            ++i;
        }
        this.positionInCache = 0;
    }

    static /* synthetic */ boolean[] access$002(DictionaryBasedBreakIterator x0, boolean[] x1) {
        x0.categoryFlags = x1;
        return x1;
    }

    protected class Builder
    extends RuleBasedBreakIterator.Builder {
        private UnicodeSet dictionaryChars = new UnicodeSet();
        private String dictionaryExpression = "";

        public Builder() {
            super(DictionaryBasedBreakIterator.this);
        }

        protected void handleSpecialSubstitution(String replace, String replaceWith, int startPos, String description) {
            super.handleSpecialSubstitution(replace, replaceWith, startPos, description);
            if (replace.equals(DictionaryBasedBreakIterator.DICTIONARY_VAR)) {
                if (replaceWith.charAt(0) == '(') {
                    this.error("Dictionary group can't be enclosed in (", startPos, description);
                }
                this.dictionaryExpression = replaceWith;
                this.dictionaryChars = new UnicodeSet(replaceWith, false);
            }
        }

        protected void buildCharCategories(Vector tempRuleList) {
            super.buildCharCategories(tempRuleList);
            DictionaryBasedBreakIterator.access$002(DictionaryBasedBreakIterator.this, new boolean[this.categories.size()]);
            int i = 0;
            while (i < this.categories.size()) {
                UnicodeSet cs = (UnicodeSet)this.categories.elementAt(i);
                cs.retainAll(this.dictionaryChars);
                if (!cs.isEmpty()) {
                    ((DictionaryBasedBreakIterator)DictionaryBasedBreakIterator.this).categoryFlags[i] = true;
                }
                ++i;
            }
        }

        protected void mungeExpressionList(Hashtable expressions) {
            expressions.put(this.dictionaryExpression, this.dictionaryChars);
        }
    }
}

