/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.util.ArrayList;

public class StringUtils {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    private StringUtils() {
    }

    public static boolean startsWithIgnoreWhitespaces(String prefix, String string) {
        int index2;
        int index1 = 0;
        int length1 = prefix.length();
        int length2 = string.length();
        int ch1 = 32;
        int ch2 = 32;
        for (index2 = 0; index1 < length1 && index2 < length2; ++index1, ++index2) {
            while (index1 < length1) {
                char c = prefix.charAt(index1);
                ch1 = c;
                if (!Character.isWhitespace(c)) break;
                ++index1;
            }
            while (index2 < length2) {
                char c = string.charAt(index2);
                ch2 = c;
                if (!Character.isWhitespace(c)) break;
                ++index2;
            }
            if (index1 == length1 && index2 == length2) {
                return true;
            }
            if (ch1 == ch2) continue;
            return false;
        }
        return index1 >= length1 || index2 < length2;
    }

    public static String[] split(String str, char separatorChar) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match) {
                    list.add(str.substring(start, i));
                    match = false;
                }
                start = ++i;
                continue;
            }
            match = true;
            ++i;
        }
        if (match) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String strip(String str) {
        return StringUtils.strip(str, null);
    }

    public static String strip(String str, String stripChars) {
        if (str == null) {
            return str;
        }
        int len = str.length();
        if (len == 0) {
            return str;
        }
        int start = StringUtils.getStripStart(str, stripChars);
        if (start == len) {
            return "";
        }
        int end = StringUtils.getStripEnd(str, stripChars);
        return start == 0 && end == len ? str : str.substring(start, end);
    }

    public static String stripStart(String str, String stripChars) {
        int start = StringUtils.getStripStart(str, stripChars);
        return start <= 0 ? str : str.substring(start);
    }

    private static int getStripStart(String str, String stripChars) {
        int start;
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return -1;
        }
        if (stripChars == null) {
            for (start = 0; start != strLen && Character.isWhitespace(str.charAt(start)); ++start) {
            }
        } else {
            if (stripChars.length() == 0) {
                return start;
            }
            while (start != strLen && stripChars.indexOf(str.charAt(start)) != -1) {
                ++start;
            }
        }
        return start;
    }

    public static String stripEnd(String str, String stripChars) {
        int end = StringUtils.getStripEnd(str, stripChars);
        return end < 0 ? str : str.substring(0, end);
    }

    private static int getStripEnd(String str, String stripChars) {
        int end;
        if (str == null || (end = str.length()) == 0) {
            return -1;
        }
        if (stripChars == null) {
            while (end != 0 && Character.isWhitespace(str.charAt(end - 1))) {
                --end;
            }
        } else {
            if (stripChars.length() == 0) {
                return end;
            }
            while (end != 0 && stripChars.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return end;
    }
}

