/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authorization;

import javax.security.auth.Subject;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import org.apache.axis.AxisFault;
import org.apache.axis.handlers.BasicHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceContextException;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.config.ConfigException;
import org.globus.wsrf.impl.security.authorization.ServiceAuthorizationChain;
import org.globus.wsrf.impl.security.authorization.exceptions.AuthorizationException;
import org.globus.wsrf.impl.security.authorization.exceptions.CloseException;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.SecureResourcePropertiesHelper;
import org.globus.wsrf.impl.security.descriptor.SecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.SecurityPropertiesHelper;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityConfig;
import org.globus.wsrf.impl.security.util.AuthUtil;
import org.globus.wsrf.impl.security.util.PDPUtils;
import org.globus.wsrf.utils.ContextUtils;

public class AuthorizationHandler
extends BasicHandler {
    private static Log logger = LogFactory.getLog((String)AuthorizationHandler.class.getName());

    public void invoke(org.apache.axis.MessageContext messageContext) throws AxisFault {
        logger.debug((Object)"Authorization");
        Subject subject = (Subject)messageContext.getProperty("callerSubject");
        if (subject == null) {
            logger.debug((Object)"No authenticaiton done, so no authz");
            return;
        }
        String servicePath = ContextUtils.getTargetServicePath(messageContext);
        if (servicePath == null) {
            return;
        }
        logger.debug((Object)("Service path " + servicePath));
        Boolean authzReq = (Boolean)messageContext.getProperty("org.globus.security.authz.required");
        if (authzReq != null && authzReq.equals(Boolean.FALSE)) {
            logger.debug((Object)"Authz not required, since auth not enforced");
            return;
        }
        Resource resource = null;
        try {
            ResourceContext context = ResourceContext.getResourceContext((SOAPMessageContext)messageContext);
            resource = context.getResource();
        }
        catch (ResourceContextException exp) {
            resource = null;
            logger.debug((Object)"Error getting resource/may not exist", (Throwable)exp);
        }
        catch (ResourceException exp) {
            resource = null;
            logger.debug((Object)"Error getting resource/may not exist", (Throwable)exp);
        }
        logger.debug((Object)("Resource is null: " + (resource == null)));
        ServiceAuthorizationChain authzChain = null;
        SecurityDescriptor secDesc = null;
        if (resource != null && (secDesc = SecureResourcePropertiesHelper.getResourceSecDescriptor(resource)) != null) {
            try {
                authzChain = SecureResourcePropertiesHelper.getAuthzChain(resource);
            }
            catch (ConfigException exp) {
                throw AxisFault.makeFault((Exception)((Object)exp));
            }
        }
        logger.debug((Object)("Sec desc after resource is " + (secDesc != null)));
        if (authzChain == null) {
            try {
                secDesc = ServiceSecurityConfig.getSecurityDescriptor(servicePath);
            }
            catch (ConfigException exp) {
                throw AxisFault.makeFault((Exception)((Object)exp));
            }
            if (secDesc != null) {
                authzChain = secDesc.getAuthzChain();
            }
        }
        logger.debug((Object)("Sec desc after service is " + (secDesc != null)));
        if (authzChain == null) {
            try {
                ContainerSecurityConfig config = ContainerSecurityConfig.getConfig();
                secDesc = config.getSecurityDescriptor();
                if (secDesc != null) {
                    authzChain = secDesc.getAuthzChain();
                }
                if (authzChain == null && config.getSecurityDescriptorFile() == null) {
                    logger.debug((Object)"Insecure container");
                    secDesc = null;
                }
            }
            catch (ConfigException exp) {
                throw AxisFault.makeFault((Exception)((Object)exp));
            }
        }
        logger.debug((Object)("Sec desc after container is " + (secDesc != null)));
        if (secDesc == null) {
            logger.debug((Object)"Insecure setting, return");
            return;
        }
        if (authzChain == null) {
            logger.debug((Object)"Sec desc is present, default authz chain");
            String authzString = this.getDefaultAuthzChain(servicePath, resource);
            try {
                authzChain = PDPUtils.getServiceAuthzChain(authzString, servicePath);
            }
            catch (ConfigException exp) {
                throw AxisFault.makeFault((Exception)((Object)exp));
            }
        }
        logger.debug((Object)"Invoking authorize on authz chain");
        try {
            authzChain.authorize(subject, (MessageContext)messageContext, servicePath);
        }
        catch (AuthorizationException e) {
            throw AxisFault.makeFault((Exception)((Object)e));
        }
        finally {
            try {
                authzChain.close();
            }
            catch (CloseException e) {
                throw AxisFault.makeFault((Exception)e);
            }
        }
    }

    private String getDefaultAuthzChain(String servicePath, Resource resource) {
        boolean gridMapPresent;
        String interceptor = null;
        try {
            gridMapPresent = SecurityPropertiesHelper.gridMapPresent(servicePath, resource);
        }
        catch (ConfigException exp) {
            gridMapPresent = false;
        }
        interceptor = !gridMapPresent ? AuthUtil.getPDPName("self") : AuthUtil.getPDPName("gridmap");
        return interceptor;
    }
}

