/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.rsclient.elements.pool;

import org.apache.log4j.Logger;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementLifeSpanGC;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceWSRFType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceWSType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.pool.PoolObjectConfig;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSBLOBWriter;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSFullWriter;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSTEXTWriter;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSXMLWriter;

public abstract class RSPoolObject {
    private static Logger log = Logger.getLogger(RSPoolObject.class);

    public static RSPoolObject getPoolObjectInstance(PoolObjectType type, PoolObjectConfig config) throws Exception {
        switch (type) {
            case WriterBLOB: {
                RSBLOBWriter writer = RSBLOBWriter.getRSBLOBWriter(new PropertyElementBase[]{new PropertyElementLifeSpanGC(Long.MAX_VALUE)}, config.FlowControl);
                switch (config.ResourceType) {
                    case WSRFType: {
                        log.debug((Object)("instantiating object " + PoolObjectType.WriterBLOB.toString() + ":" + PoolObjectResourceType.WSRFType.toString()));
                        if (config.ServiceEndPoint == null) {
                            writer.getRSLocator(new RSResourceWSRFType());
                            break;
                        }
                        writer.getRSLocator(new RSResourceWSRFType(config.ServiceEndPoint));
                        break;
                    }
                    case WSType: {
                        log.debug((Object)("instantiating object " + PoolObjectType.WriterBLOB.toString() + ":" + PoolObjectResourceType.WSType.toString()));
                        if (config.ServiceEndPoint == null) {
                            writer.getRSLocator(new RSResourceWSType());
                            break;
                        }
                        writer.getRSLocator(new RSResourceWSType(config.ServiceEndPoint));
                    }
                }
                return writer;
            }
            case WriterFull: {
                RSFullWriter writer = RSFullWriter.getRSFullWriter(new PropertyElementBase[]{new PropertyElementLifeSpanGC(Long.MAX_VALUE)}, config.FlowControl);
                switch (config.ResourceType) {
                    case WSRFType: {
                        log.debug((Object)("instantiating object " + PoolObjectType.WriterFull.toString() + ":" + PoolObjectResourceType.WSRFType.toString()));
                        if (config.ServiceEndPoint == null) {
                            writer.getRSLocator(new RSResourceWSRFType());
                            break;
                        }
                        writer.getRSLocator(new RSResourceWSRFType(config.ServiceEndPoint));
                        break;
                    }
                    case WSType: {
                        log.debug((Object)("instantiating object " + PoolObjectType.WriterFull.toString() + ":" + PoolObjectResourceType.WSType.toString()));
                        if (config.ServiceEndPoint == null) {
                            writer.getRSLocator(new RSResourceWSType());
                            break;
                        }
                        writer.getRSLocator(new RSResourceWSType(config.ServiceEndPoint));
                    }
                }
                return writer;
            }
            case WriterText: {
                RSTEXTWriter writer = RSTEXTWriter.getRSTEXTWriter(new PropertyElementBase[]{new PropertyElementLifeSpanGC(Long.MAX_VALUE)}, config.WellFormed, config.FlowControl);
                switch (config.ResourceType) {
                    case WSRFType: {
                        log.debug((Object)("instantiating object " + PoolObjectType.WriterText.toString() + ":" + PoolObjectResourceType.WSRFType.toString()));
                        if (config.ServiceEndPoint == null) {
                            writer.getRSLocator(new RSResourceWSRFType());
                            break;
                        }
                        writer.getRSLocator(new RSResourceWSRFType(config.ServiceEndPoint));
                        break;
                    }
                    case WSType: {
                        log.debug((Object)("instantiating object " + PoolObjectType.WriterText.toString() + ":" + PoolObjectResourceType.WSType.toString()));
                        if (config.ServiceEndPoint == null) {
                            writer.getRSLocator(new RSResourceWSType());
                            break;
                        }
                        writer.getRSLocator(new RSResourceWSType(config.ServiceEndPoint));
                    }
                }
                return writer;
            }
            case WriterXML: {
                RSXMLWriter writer = RSXMLWriter.getRSXMLWriter(new PropertyElementBase[]{new PropertyElementLifeSpanGC(Long.MAX_VALUE)}, config.FlowControl);
                switch (config.ResourceType) {
                    case WSRFType: {
                        log.debug((Object)("instantiating object " + PoolObjectType.WriterXML.toString() + ":" + PoolObjectResourceType.WSRFType.toString()));
                        if (config.ServiceEndPoint == null) {
                            writer.getRSLocator(new RSResourceWSRFType());
                            break;
                        }
                        writer.getRSLocator(new RSResourceWSRFType(config.ServiceEndPoint));
                        break;
                    }
                    case WSType: {
                        log.debug((Object)("instantiating object " + PoolObjectType.WriterXML.toString() + ":" + PoolObjectResourceType.WSType.toString()));
                        if (config.ServiceEndPoint == null) {
                            writer.getRSLocator(new RSResourceWSType());
                            break;
                        }
                        writer.getRSLocator(new RSResourceWSType(config.ServiceEndPoint));
                    }
                }
                return writer;
            }
        }
        throw new Exception("Non recognizable pool object type");
    }

    public static enum PoolObjectResourceType {
        WSRFType,
        WSType;

    }

    public static enum PoolObjectType {
        WriterFull,
        WriterBLOB,
        WriterText,
        WriterXML;

    }
}

