/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds.aggregator.impl;

import java.text.DateFormat;
import java.util.Calendar;
import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.mds.aggregator.impl.AggregatorServiceGroupEntryRemovedCallback;
import org.globus.mds.aggregator.impl.AggregatorServiceGroupResource;
import org.globus.mds.aggregator.impl.AggregatorSource;
import org.globus.mds.aggregator.types.AggregatorContent;
import org.globus.mds.aggregator.types.PairedKeyType;
import org.globus.mds.usefulrp.ServiceMetaDataResourceProperty;
import org.globus.wsrf.RemoveCallback;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.ResourceLifetime;
import org.globus.wsrf.ResourceProperties;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertyMetaData;
import org.globus.wsrf.ResourcePropertySet;
import org.globus.wsrf.impl.ReflectionResourceProperty;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.globus.wsrf.impl.SimpleResourceProperty;
import org.globus.wsrf.impl.SimpleResourcePropertyMetaData;
import org.globus.wsrf.impl.SimpleResourcePropertySet;
import org.globus.wsrf.impl.servicegroup.ServiceGroupConstants;
import org.globus.wsrf.impl.servicegroup.ServiceGroupEntryResource;

public class AggregatorServiceGroupEntryResource
implements ServiceGroupEntryResource,
ResourceProperties,
ResourceLifetime,
RemoveCallback {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$mds$aggregator$impl$AggregatorServiceGroupEntryResource == null ? (class$org$globus$mds$aggregator$impl$AggregatorServiceGroupEntryResource = AggregatorServiceGroupEntryResource.class$("org.globus.mds.aggregator.impl.AggregatorServiceGroupEntryResource")) : class$org$globus$mds$aggregator$impl$AggregatorServiceGroupEntryResource).getName());
    public static final QName RP_SET = new QName("http://mds.globus.org/aggregator", "AggregatorServiceGroupEntryRP");
    private ResourceKey key = null;
    private ResourcePropertySet propSet = null;
    private EndpointReferenceType entryEPR = null;
    private EndpointReferenceType memberEPR = null;
    private EndpointReferenceType serviceGroupEPR = null;
    private ResourceProperty contentRP = null;
    private ResourceProperty memberRP = null;
    private ResourceProperty serviceGroupEPRRP = null;
    private ServiceMetaDataResourceProperty metadata = null;
    private AggregatorContent content = null;
    private AggregatorSource source = null;
    private AggregatorServiceGroupResource aggrResource = null;
    Calendar terminationTime = null;
    DateFormat dateFormat = DateFormat.getTimeInstance(0);
    static /* synthetic */ Class class$org$globus$mds$aggregator$impl$AggregatorServiceGroupEntryResource;

    public AggregatorServiceGroupEntryResource(AggregatorServiceGroupResource aggrResource, EndpointReferenceType memberEPR, EndpointReferenceType serviceGroupEPR, AggregatorContent content) {
        this.aggrResource = aggrResource;
        this.memberEPR = memberEPR;
        this.serviceGroupEPR = serviceGroupEPR;
        this.content = content;
        try {
            this.propSet = new SimpleResourcePropertySet(RP_SET);
            PairedKeyType pk = new PairedKeyType();
            pk.setGroupKey((String)this.aggrResource.getKey().getValue());
            pk.setEntryKey(String.valueOf(this.hashCode()));
            this.key = new SimpleResourceKey(ServiceGroupConstants.ENTRY_KEY, (Object)pk);
            this.initializeServiceGroupRPs();
            this.initializeLifetimeRPs();
            this.metadata = new ServiceMetaDataResourceProperty();
            this.propSet.add((ResourceProperty)this.metadata);
        }
        catch (Exception e) {
            logger.error((Object)("Exception constructing service group entry: " + e));
        }
    }

    private void initializeLifetimeRPs() throws Exception {
        ReflectionResourceProperty prop = new ReflectionResourceProperty((ResourcePropertyMetaData)SimpleResourcePropertyMetaData.TERMINATION_TIME, (Object)this);
        this.propSet.add((ResourceProperty)prop);
        prop = new ReflectionResourceProperty((ResourcePropertyMetaData)SimpleResourcePropertyMetaData.CURRENT_TIME, (Object)this);
        this.propSet.add((ResourceProperty)prop);
    }

    private void initializeServiceGroupRPs() throws Exception {
        this.contentRP = new SimpleResourceProperty(ServiceGroupConstants.CONTENT);
        this.propSet.add(this.contentRP);
        this.setContent(this.content);
        this.memberRP = new SimpleResourceProperty(ServiceGroupConstants.MEMBER_EPR);
        this.memberRP.add((Object)this.memberEPR);
        this.propSet.add(this.memberRP);
        this.serviceGroupEPRRP = new SimpleResourceProperty(ServiceGroupConstants.SERVICE_GROUP_EPR);
        this.serviceGroupEPRRP.add((Object)this.serviceGroupEPR);
        this.propSet.add(this.serviceGroupEPRRP);
    }

    public void setVersion(String version) {
        this.metadata.setVersion(version);
    }

    public ResourcePropertySet getResourcePropertySet() {
        return this.propSet;
    }

    public ResourceKey getKey() {
        return this.key;
    }

    public EndpointReferenceType getEntryEPR() {
        return this.entryEPR;
    }

    public void setEntryEPR(EndpointReferenceType epr) {
        this.entryEPR = epr;
    }

    public EndpointReferenceType getMemberEPR() {
        return this.memberEPR;
    }

    public void setAggregatorSource(AggregatorSource source) {
        this.source = source;
    }

    public AggregatorSource getAggregatorSource() {
        return this.source;
    }

    public AggregatorContent getContent() {
        return this.content;
    }

    public void setContent(AggregatorContent content) {
        if (content == null) {
            return;
        }
        this.content = content;
        this.contentRP.clear();
        this.contentRP.add((Object)this.content);
        if (this.aggrResource.getConfiguration().getNotifyOnEntryContentChangeValue()) {
            this.aggrResource.notifyChange();
        }
    }

    public Calendar getCurrentTime() {
        Calendar now = Calendar.getInstance();
        logger.debug((Object)("getCurrentTime()=" + this.dateFormat.format(now.getTime())));
        return now;
    }

    public Calendar getTerminationTime() {
        if (this.terminationTime != null) {
            logger.debug((Object)("getTerminationTime()=" + this.dateFormat.format(this.terminationTime.getTime())));
        } else {
            logger.debug((Object)"getTerminationTime() returns null");
        }
        return this.terminationTime;
    }

    public void setTerminationTime(Calendar t) {
        Calendar now = Calendar.getInstance();
        logger.debug((Object)("setTerminationTime()=" + this.dateFormat.format(t.getTime()) + ", invoked at " + this.dateFormat.format(now.getTime())));
        if (now.after(t)) {
            logger.warn((Object)"New termination time is in past!");
        }
        this.terminationTime = t;
        if (this.aggrResource.getConfiguration().getNotifyOnEntryLifetimeExtensionValue()) {
            this.aggrResource.notifyChange();
        }
    }

    public void remove() throws ResourceException {
        AggregatorServiceGroupEntryRemovedCallback callback;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removed a service group entry resource: " + this.toString()));
        }
        if ((callback = this.aggrResource.getConfiguration().getEntryRemovedCallbackInstance()) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking remove method for AggregatorServiceGroupEntryRemoveCallback class: " + callback.getClass().getName()));
            }
            try {
                callback.remove(this);
            }
            catch (Exception e) {
                throw new ResourceException("Unhandled Exception during remove callback", (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

