/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.builder;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.cli2.Argument;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.option.Command;
import org.apache.commons.cli2.resource.ResourceHelper;

public class CommandBuilder {
    private String preferredName;
    private String description;
    private Set aliases;
    private boolean required;
    private Argument argument;
    private Group children;
    private int id;

    public CommandBuilder() {
        this.reset();
    }

    public Command create() {
        if (this.preferredName == null) {
            throw new IllegalStateException(ResourceHelper.getResourceHelper().getMessage("Option.no.name"));
        }
        Command option = new Command(this.preferredName, this.description, this.aliases, this.required, this.argument, this.children, this.id);
        this.reset();
        return option;
    }

    public CommandBuilder reset() {
        this.preferredName = null;
        this.description = null;
        this.aliases = new HashSet();
        this.required = false;
        this.argument = null;
        this.children = null;
        this.id = 0;
        return this;
    }

    public CommandBuilder withName(String name) {
        if (this.preferredName == null) {
            this.preferredName = name;
        } else {
            this.aliases.add(name);
        }
        return this;
    }

    public CommandBuilder withDescription(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public CommandBuilder withRequired(boolean newRequired) {
        this.required = newRequired;
        return this;
    }

    public CommandBuilder withChildren(Group newChildren) {
        this.children = newChildren;
        return this;
    }

    public CommandBuilder withArgument(Argument newArgument) {
        this.argument = newArgument;
        return this;
    }

    public final CommandBuilder withId(int newId) {
        this.id = newId;
        return this;
    }
}

