/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public abstract class ASN1TaggedObject
extends DERObject {
    int tagNo;
    boolean empty = false;
    boolean explicit = true;
    DEREncodable obj = null;

    public static ASN1TaggedObject getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        if (bl) {
            return (ASN1TaggedObject)aSN1TaggedObject.getObject();
        }
        throw new IllegalArgumentException("implicitly tagged tagged object");
    }

    public ASN1TaggedObject(int n, DEREncodable dEREncodable) {
        this.explicit = true;
        this.tagNo = n;
        this.obj = dEREncodable;
    }

    public ASN1TaggedObject(boolean bl, int n, DEREncodable dEREncodable) {
        this.explicit = bl;
        this.tagNo = n;
        this.obj = dEREncodable;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ASN1TaggedObject)) {
            return false;
        }
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)object;
        if (this.tagNo != aSN1TaggedObject.tagNo || this.empty != aSN1TaggedObject.empty || this.explicit != aSN1TaggedObject.explicit) {
            return false;
        }
        return !(this.obj == null ? aSN1TaggedObject.obj != null : !this.obj.equals(aSN1TaggedObject.obj));
    }

    public int hashCode() {
        int n = this.tagNo;
        if (this.obj != null) {
            n ^= this.obj.hashCode();
        }
        return n;
    }

    public int getTagNo() {
        return this.tagNo;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public DERObject getObject() {
        if (this.obj != null) {
            return this.obj.getDERObject();
        }
        return null;
    }

    abstract void encode(DEROutputStream var1) throws IOException;
}

