/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.addressing.handler;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.ServiceFactory;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.TransformerFactory;
import org.apache.axis.message.addressing.Action;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.Constants;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.MessageID;
import org.apache.axis.message.addressing.To;
import org.apache.axis.message.addressing.util.AddressingUtils;
import org.apache.axis.types.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.addressing.handler.AbstractAddressingHandler;

public class ServerSideAddressingHandler
extends AbstractAddressingHandler {
    private static final Log LOG = LogFactory.getLog((String)(class$org$apache$ws$addressing$handler$ServerSideAddressingHandler == null ? (class$org$apache$ws$addressing$handler$ServerSideAddressingHandler = ServerSideAddressingHandler.class$("org.apache.ws.addressing.handler.ServerSideAddressingHandler")) : class$org$apache$ws$addressing$handler$ServerSideAddressingHandler).getName());
    public static ThreadLocal TRANSFORMER_FACTORY = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return TransformerFactory.newInstance();
        }
    };
    static /* synthetic */ Class class$org$apache$ws$addressing$handler$ServerSideAddressingHandler;

    public boolean handleRequest(MessageContext msgContext) {
        SOAPMessageContext soapMsgContext = (SOAPMessageContext)msgContext;
        try {
            SOAPMessage msg = soapMsgContext.getMessage();
            if (msg == null) {
                return true;
            }
            AddressingHeaders headers = new AddressingHeaders(msg.getSOAPPart().getEnvelope(), this.getActor(), true, this.isRemoveHeadersEnabled(), false, this.getReferencePropertyQNames());
            msgContext.setProperty("org.apache.axis.message.addressing.REQUEST.HEADERS", (Object)headers);
            this.setTargetService(soapMsgContext, headers);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new JAXRPCException("unexpected error in handleRequest()", (Throwable)e);
        }
        return true;
    }

    public boolean handleResponse(MessageContext msgContext) {
        SOAPMessageContext soapMsgContext = (SOAPMessageContext)msgContext;
        try {
            SOAPMessage msg = soapMsgContext.getMessage();
            if (msg == null) {
                return true;
            }
            AddressingHeaders reqHeaders = (AddressingHeaders)msgContext.getProperty("org.apache.axis.message.addressing.REQUEST.HEADERS");
            if (reqHeaders == null) {
                return true;
            }
            AddressingHeaders resHeaders = AddressingUtils.getResponseHeaders(msgContext);
            resHeaders.setSetMustUnderstand(this.isMustUnderstandEnabled(msgContext));
            this.processFromHeader(reqHeaders, resHeaders);
            this.processActionHeader(reqHeaders, resHeaders);
            this.processToHeader(reqHeaders, resHeaders);
            this.processRelatesToHeader(reqHeaders, resHeaders);
            this.processMessageIdHeader(resHeaders);
            resHeaders.toEnvelope(msg.getSOAPPart().getEnvelope(), this.getActor());
            this.processReplyToHeader(reqHeaders, soapMsgContext);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new JAXRPCException("unexpected error in handleResponse()", (Throwable)e);
        }
        return true;
    }

    public boolean handleFault(MessageContext msgContext) {
        SOAPMessageContext soapMsgContext = (SOAPMessageContext)msgContext;
        try {
            AddressingHeaders reqHeaders = (AddressingHeaders)msgContext.getProperty("org.apache.axis.message.addressing.REQUEST.HEADERS");
            if (reqHeaders == null) {
                return true;
            }
            AddressingHeaders resHeaders = AddressingUtils.getResponseHeaders(msgContext);
            this.processFromHeader(reqHeaders, resHeaders);
            if ("http://schemas.xmlsoap.org/ws/2004/03/addressing".equals("http://schemas.xmlsoap.org/ws/2004/03/addressing")) {
                resHeaders.setAction(new Action(new URI("http://schemas.xmlsoap.org/ws/2004/03/addressing/fault")));
            }
            this.addRelatesToHeader(reqHeaders, resHeaders);
            this.addMessageIdHeader(resHeaders);
            this.addAddressingHeadersToSOAPEnvelope(soapMsgContext, resHeaders);
            this.processFaultToHeader(reqHeaders, soapMsgContext);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new JAXRPCException("unexpected error in handleFault()", (Throwable)e);
        }
        return true;
    }

    protected void forwardMessage(SOAPMessageContext soapMsgContext, EndpointReference endpointRef) {
        try {
            SOAPConnection soapConn = SOAPConnectionFactory.newInstance().createConnection();
            soapConn.call(soapMsgContext.getMessage(), (Object)this.toURL(endpointRef.getAddress()));
            soapConn.close();
            SOAPBody responseBody = soapMsgContext.getMessage().getSOAPPart().getEnvelope().getBody();
            ServerSideAddressingHandler.removeAllChildElements((SOAPElement)responseBody);
        }
        catch (Exception e) {
            throw new JAXRPCException("Failed to forward SOAP message.");
        }
    }

    private URL toURL(AttributedURI addr) throws MalformedURLException {
        return new URL(addr.toString());
    }

    protected Service getService(MessageContext msgContext) throws ServiceException {
        return ServiceFactory.newInstance().createService(new QName(""));
    }

    protected void configureCall(Call call, MessageContext oldContext) {
    }

    protected String getTargetServiceName(AddressingHeaders headers) throws Exception {
        To toURI = headers.getTo();
        if (toURI == null) {
            return null;
        }
        String to = toURI.getPath();
        if (to == null) {
            return null;
        }
        return to.substring(to.lastIndexOf(47) + 1);
    }

    protected void setTargetService(SOAPMessageContext soapMsgContext, AddressingHeaders headers) throws Exception {
    }

    private void processFromHeader(AddressingHeaders requestAddrHeaders, AddressingHeaders responseAddrHeaders) {
        To toURI;
        EndpointReference fromEPR = responseAddrHeaders.getFrom();
        if (fromEPR == null && (toURI = requestAddrHeaders.getTo()) != null) {
            fromEPR = new EndpointReference(toURI);
            fromEPR.setProperties(requestAddrHeaders.getReferenceProperties());
            responseAddrHeaders.setFrom(fromEPR);
        }
    }

    private void processActionHeader(AddressingHeaders requestAddrHeaders, AddressingHeaders responseAddrHeaders) throws URI.MalformedURIException {
        Action action = responseAddrHeaders.getAction();
        if (action == null && (action = requestAddrHeaders.getAction()) != null) {
            responseAddrHeaders.setAction(new Action(new URI(action.toString() + "Response")));
        }
    }

    private void processToHeader(AddressingHeaders requestAddrHeaders, AddressingHeaders responseAddrHeaders) throws URI.MalformedURIException {
        if (responseAddrHeaders.getFrom() == null && requestAddrHeaders.getFrom() != null) {
            responseAddrHeaders.setTo(requestAddrHeaders.getFrom().getAddress());
        } else {
            responseAddrHeaders.setTo(new To("http://schemas.xmlsoap.org/ws/2004/03/addressing/role/anonymous"));
        }
    }

    private void processRelatesToHeader(AddressingHeaders requestAddrHeaders, AddressingHeaders responseAddrHeaders) throws URI.MalformedURIException {
        MessageID msgID = requestAddrHeaders.getMessageID();
        if (msgID != null) {
            responseAddrHeaders.addRelatesTo(msgID.toString(), Constants.QNAME_RESPONSE);
        }
    }

    private void processMessageIdHeader(AddressingHeaders responseAddrHeaders) throws URI.MalformedURIException {
        responseAddrHeaders.setMessageID(this.createMessageID());
    }

    private void processReplyToHeader(AddressingHeaders requestAddrHeaders, SOAPMessageContext soapMsgContext) throws Exception {
        String uri;
        AttributedURI address;
        EndpointReference replyTo = requestAddrHeaders.getReplyTo();
        if (replyTo != null && (address = replyTo.getAddress()) != null && (uri = address.toString()) != null && !uri.equals("http://schemas.xmlsoap.org/ws/2004/03/addressing/role/anonymous")) {
            this.forwardMessage(soapMsgContext, replyTo);
        }
    }

    private void addAddressingHeadersToSOAPEnvelope(SOAPMessageContext soapMsgContext, AddressingHeaders resHeaders) throws Exception {
        SOAPMessage msg = soapMsgContext.getMessage();
        if (msg == null) {
            throw new JAXRPCException("Unable to obtain response message from SOAP message context.");
        }
        resHeaders.toEnvelope(msg.getSOAPPart().getEnvelope());
    }

    private void processFaultToHeader(AddressingHeaders reqHeaders, SOAPMessageContext soapMsgContext) throws Exception {
        AttributedURI address;
        EndpointReference faultTo = reqHeaders.getFaultTo();
        if (faultTo != null && (address = faultTo.getAddress()) != null && address.toString() != null) {
            this.forwardMessage(soapMsgContext, faultTo);
        }
    }

    private void addRelatesToHeader(AddressingHeaders reqHeaders, AddressingHeaders resHeaders) throws URI.MalformedURIException {
        MessageID msgID = reqHeaders.getMessageID();
        if (msgID != null) {
            resHeaders.addRelatesTo(msgID.toString(), Constants.QNAME_RESPONSE);
        }
    }

    private void addMessageIdHeader(AddressingHeaders resHeaders) throws URI.MalformedURIException {
        MessageID msgID = new MessageID(new URI("uuid:" + this.generateUUId()));
        resHeaders.setMessageID(msgID);
    }

    protected static void removeAllChildElements(SOAPElement soapElem) {
        Iterator iter = soapElem.getChildElements();
        List children = ServerSideAddressingHandler.toList(iter);
        for (int i = 0; i < children.size(); ++i) {
            Node child = (Node)children.get(i);
            if (child.getParentElement() == null) continue;
            child.detachNode();
            child.recycleNode();
        }
    }

    private static List toList(Iterator iter) {
        ArrayList list = new ArrayList();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

