/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class ResourceReader {
    private BufferedReader reader;
    private String resourceName;
    private String encoding;
    private boolean isReset;

    public ResourceReader(String resourceName, String encoding) throws UnsupportedEncodingException {
        this.resourceName = resourceName;
        this.encoding = encoding;
        this.isReset = false;
        this._reset();
    }

    public ResourceReader(String resourceName) {
        this.resourceName = resourceName;
        this.encoding = null;
        this.isReset = false;
        try {
            this._reset();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String readLine() throws IOException {
        if (this.isReset) {
            this.isReset = false;
            String line = this.reader.readLine();
            if (line.charAt(0) == '\uffef' || line.charAt(0) == '\ufeff') {
                return line.substring(1);
            }
            return line;
        }
        return this.reader.readLine();
    }

    public void reset() {
        try {
            this._reset();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private void _reset() throws UnsupportedEncodingException {
        if (this.isReset) {
            return;
        }
        InputStream is = this.getClass().getResourceAsStream(this.resourceName);
        if (is == null) {
            throw new IllegalArgumentException("Can't open " + this.resourceName);
        }
        InputStreamReader isr = this.encoding == null ? new InputStreamReader(is) : new InputStreamReader(is, this.encoding);
        this.reader = new BufferedReader(isr);
        this.isReset = true;
    }
}

