/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.channel.events;

import gr.uoa.di.madgik.commons.channel.events.BytePayloadChannelEvent;
import gr.uoa.di.madgik.commons.channel.events.ChannelStateEvent;
import gr.uoa.di.madgik.commons.channel.events.DisposeChannelEvent;
import gr.uoa.di.madgik.commons.channel.events.ObjectPayloadChannelEvent;
import gr.uoa.di.madgik.commons.channel.events.StringPayloadChannelEvent;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChannelState {
    private static Logger logger = Logger.getLogger(ChannelState.class.getName());
    private Map<Integer, ChannelStateEvent> ChannelEvents = null;

    public ChannelState() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created new ChannelState and initializing Event List");
        }
        this.ChannelEvents = new Hashtable<Integer, ChannelStateEvent>();
        this.InitEvents();
    }

    public Collection<ChannelStateEvent> GetChannelEvents() {
        return this.ChannelEvents.values();
    }

    public ChannelStateEvent GetEvent(EventName EventToRetrieve) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Retrieving Event from Channel " + EventToRetrieve.toString());
        }
        if (!this.ChannelEvents.containsKey(EventToRetrieve.ordinal())) {
            return null;
        }
        return this.ChannelEvents.get(EventToRetrieve.ordinal());
    }

    private void InitEvents() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Initializing Event list of Channel");
        }
        if (this.ChannelEvents.size() != 0) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "The Channel State Event vector has already been initialized. Reseting it would cause dangling Observers");
            }
            throw new IllegalStateException("The Channel State Event vector has already been initialized. Reseting it would cause dangling Observers");
        }
        this.ChannelEvents.put(EventName.DisposeChannel.ordinal(), new DisposeChannelEvent());
        this.ChannelEvents.put(EventName.BytePayload.ordinal(), new BytePayloadChannelEvent());
        this.ChannelEvents.put(EventName.StringPayload.ordinal(), new StringPayloadChannelEvent());
        this.ChannelEvents.put(EventName.ObjectPayload.ordinal(), new ObjectPayloadChannelEvent());
    }

    public void Dispose() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Disposing ChannelState and unregistering observers");
        }
        for (Map.Entry<Integer, ChannelStateEvent> registeredEvent : this.ChannelEvents.entrySet()) {
            registeredEvent.getValue().deleteObservers();
        }
        this.ChannelEvents.clear();
    }

    public static enum EventName {
        DisposeChannel,
        BytePayload,
        StringPayload,
        ObjectPayload;

    }
}

