/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.util;

import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSNoRawContent;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSPropertyCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSRawContentAsUrl;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSRawContentInLocation;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSRawContentInMessage;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSRawContentInMessageConditional;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSRawContentLocationConfig;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.PropertyCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.util.ObjectToWSConditionsConverter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.util.WSToObjectConditionsConverter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.content.NoRawContent;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.content.RawContentAsUrl;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.content.RawContentInLocation;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.content.RawContentInMessage;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.content.RawContentInMessageConditional;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.content.RawContentLocationConfig;

public class RawContentLocationConverter {
    public static WSRawContentLocationConfig convertToWSRawContentLocationConfig(RawContentLocationConfig config) {
        WSRawContentLocationConfig contentLocationConfig = new WSRawContentLocationConfig();
        switch (config.getType()) {
            case NONE: {
                contentLocationConfig.setNoRawContent(new WSNoRawContent());
                break;
            }
            case INMESSAGE: {
                contentLocationConfig.setRawContentInMessage(new WSRawContentInMessage());
                break;
            }
            case INMESSAGE_CONDITIONAL: {
                RawContentInMessageConditional conditional = (RawContentInMessageConditional)config;
                PropertyCondition propertyCondition = conditional.getPropertyCondition();
                WSPropertyCondition wsPropertyCondition = ObjectToWSConditionsConverter.convertToWsPropertyCondition(propertyCondition);
                contentLocationConfig.setRawContentInMessageConditional(new WSRawContentInMessageConditional(wsPropertyCondition));
                break;
            }
            case LOCATION: {
                contentLocationConfig.setRawContentInLocation(new WSRawContentInLocation(((RawContentInLocation)config).getLocation()));
                break;
            }
            case AS_URL: {
                contentLocationConfig.setRawContentAsUrl(new WSRawContentAsUrl());
            }
        }
        return contentLocationConfig;
    }

    public static RawContentLocationConfig convertToRawContentLocationConfig(WSRawContentLocationConfig config) {
        if (config.getNoRawContent() != null) {
            return NoRawContent.instance();
        }
        if (config.getRawContentInMessage() != null) {
            return RawContentInMessage.instance();
        }
        if (config.getRawContentInMessageConditional() != null) {
            WSRawContentInMessageConditional wsRawContentInMessageConditional = config.getRawContentInMessageConditional();
            PropertyCondition propertyCondition = WSToObjectConditionsConverter.convertToPropertyCondition(wsRawContentInMessageConditional.getCondition());
            return new RawContentInMessageConditional(propertyCondition);
        }
        if (config.getRawContentInLocation() != null) {
            return new RawContentInLocation(config.getRawContentInLocation().getLocation());
        }
        if (config.getRawContentAsUrl() != null) {
            return RawContentAsUrl.instance();
        }
        return null;
    }
}

