/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.infra.nodeselection.ru;

import gr.uoa.di.madgik.commons.infra.HostingNode;
import gr.uoa.di.madgik.commons.infra.nodeselection.NodeSelector;
import gr.uoa.di.madgik.commons.infra.nodeselection.ru.RUNodeSelector;
import gr.uoa.di.madgik.commons.infra.nodeselection.ru.TimestampComparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class MRUNodeSelector
extends RUNodeSelector {
    private static Long seasonChange = Long.MIN_VALUE;

    public MRUNodeSelector(NodeSelector tieBreaker) {
        super(tieBreaker);
    }

    public MRUNodeSelector() {
    }

    @Override
    public HostingNode getRUNode(List<HostingNode> candidates) {
        Long timestamp;
        HostingNode MRUNode = null;
        HostingNode newSeasonNode = null;
        Long minInterval = Long.MAX_VALUE;
        Long newSeasonTimeStamp = Long.MIN_VALUE;
        for (HostingNode candidate : candidates) {
            if (timingInfo.get(candidate.getId()) == null) {
                MRUNode = candidate;
                break;
            }
            Long candidateTimestamp = (Long)timingInfo.get(candidate.getId());
            if (candidateTimestamp < seasonChange && minInterval > Math.abs(candidateTimestamp - seasonChange)) {
                minInterval = Math.abs(candidateTimestamp - seasonChange);
                MRUNode = candidate;
            }
            if (newSeasonTimeStamp >= candidateTimestamp) continue;
            newSeasonTimeStamp = candidateTimestamp;
            newSeasonNode = candidate;
        }
        if ((timestamp = (Long)timingInfo.get((MRUNode = MRUNode != null ? MRUNode : newSeasonNode).getId())) != null && timestamp >= seasonChange) {
            seasonChange = timestamp;
        }
        return MRUNode;
    }

    @Override
    public Map<String, Long> sortTimingInfo() {
        return new TreeMap<String, Long>(new TimestampComparator(timingInfo, false));
    }
}

