/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl.instancestates;

import java.util.Observable;
import java.util.Observer;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourcePropertySet;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.informationsystem.publisher.impl.instancestates.BaseInstanceStateHandler;
import org.gcube.common.informationsystem.publisher.impl.instancestates.WSRPDocument;
import org.gcube.informationsystem.collector.stubs.metadata.MetadataRecord;
import org.gcube.informationsystem.collector.stubs.metadata.MetadataWriter;

final class RegisterInstanceStatePushHandler
extends BaseInstanceStateHandler {
    protected static final GCUBELog logger = new GCUBELog(RegisterInstanceStatePushHandler.class);

    public RegisterInstanceStatePushHandler(GCUBEWSResource resource, GCUBEScope scope, String mode, String[] name) throws Exception {
        super(resource, scope, mode, name);
    }

    @Override
    protected void submitRequest() throws Exception {
        String resourceLog = this.getResourceName();
        logger.info((Object)("ISPublisher is going to publish the Resource Property document from " + resourceLog));
        try {
            this.register();
            this.resource.getResourcePropertySet().addObserver((Observer)new RPSetObserver(resourceLog));
        }
        catch (Exception e) {
            throw new Exception("Unable to publish RPs from " + resourceLog, e);
        }
    }

    @Override
    protected MetadataRecord getMetadata(WSRPDocument rpd, String mode) throws Exception {
        return new MetadataWriter(MetadataRecord.TYPE.INSTANCESTATE, rpd.getSource(), Integer.valueOf(31536000), "", rpd.getSourceID(), "", rpd.getNamespace(), mode).getRecord();
    }

    class RPSetObserver
    implements Observer {
        String resourceLog;

        RPSetObserver(String resourceLog) {
            this.resourceLog = resourceLog;
        }

        @Override
        public void update(Observable o, Object change) {
            GCUBEWSResourcePropertySet.RPSetChange notifiedChange = (GCUBEWSResourcePropertySet.RPSetChange)change;
            logger.trace((Object)("Resource Property " + notifiedChange.getResourceProperty().getMetaData().getName().getLocalPart() + " (belonging to " + this.resourceLog + ") was " + notifiedChange.getEvent().name()));
            try {
                RegisterInstanceStatePushHandler.this.register();
            }
            catch (Exception e) {
                logger.error((Object)("Unable to publish RPs from " + this.resourceLog), (Throwable)e);
            }
        }
    }
}

