/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.testsuite;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.publisher.ISPublisher;
import org.gcube.common.core.resources.GCUBEMCollection;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.GCUBESecurityManagerImpl;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.common.informationsystem.publisher.testsuite.GCUBEPublisherTest;

public class GCUBEPublisherParallelStressTest {
    protected static final GCUBEClientLog logger = new GCUBEClientLog(GCUBEPublisherParallelStressTest.class, new Properties[0]);
    protected static final int PARALLELISM = 2;
    protected static final int REGISTRATIONS_PER_THREAD = 500;
    static final DateFormat dateAndTimeStamp = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    public static void main(String[] args) {
        PropertyConfigurator.configure((String)(System.getenv("GLOBUS_LOCATION") + File.separator + "container-log4j.properties"));
        String file = args[0];
        GCUBEScope scope = GCUBEScope.getScope((String)args[1]);
        Integer threadStartFrom = 1;
        if (args.length == 2) {
            Integer thread = 0;
            while (thread < 2) {
                new RegistrationThread(threadStartFrom, file, scope).start();
                threadStartFrom = new Integer(threadStartFrom + 500);
                Integer n = thread;
                Integer n2 = thread = Integer.valueOf(thread + 1);
            }
        } else {
            logger.error((Object)"USAGE: GCUBEPublisherStressTest <profile file> <callerScope>");
            System.exit(0);
        }
    }

    public static class RegistrationThread
    extends Thread {
        Integer startFrom = 0;
        String file = "";
        GCUBEScope scope;

        RegistrationThread(int startFrom, String file, GCUBEScope scope) {
            this.startFrom = startFrom;
            this.scope = scope;
            this.file = file;
        }

        @Override
        public void run() {
            Integer i = 1;
            while (i <= 500) {
                try {
                    GCUBEMCollection resource = (GCUBEMCollection)GHNContext.getImplementation(GCUBEMCollection.class);
                    if (resource == null) {
                        logger.error((Object)"Failed to load from GHNContext");
                    }
                    try {
                        resource.load((Reader)new FileReader(this.file));
                        resource.setID(new Integer(i + this.startFrom).toString());
                    }
                    catch (FileNotFoundException e1) {
                        BufferedReader br = new BufferedReader(new InputStreamReader(GCUBEPublisherTest.class.getResourceAsStream(this.file)));
                        resource.load((Reader)br);
                    }
                    logger.debug((Object)this.scope.toString());
                    System.out.println("Thread ID:" + Thread.currentThread().getId() + ", " + dateAndTimeStamp.format(new Date()) + " - publishing resource #" + resource.getID());
                    GCUBESecurityManagerImpl managerSec = new GCUBESecurityManagerImpl(){

                        public boolean isSecurityEnabled() {
                            return false;
                        }
                    };
                    ISPublisher publisher = (ISPublisher)GHNContext.getImplementation(ISPublisher.class);
                    publisher.registerGCUBEResource((GCUBEResource)resource, this.scope, (GCUBESecurityManager)managerSec);
                    System.out.println("Thread ID:" + Thread.currentThread().getId() + ", " + dateAndTimeStamp.format(new Date()) + " - resource #" + resource.getID() + " published");
                    publisher.updateGCUBEResource((GCUBEResource)resource, this.scope, (GCUBESecurityManager)managerSec);
                    System.out.println("Thread ID:" + Thread.currentThread().getId() + ", " + dateAndTimeStamp.format(new Date()) + " - resource #" + resource.getID() + " updated");
                    publisher.updateGCUBEResource((GCUBEResource)resource, this.scope, (GCUBESecurityManager)managerSec);
                    System.out.println("Thread ID:" + Thread.currentThread().getId() + ", " + dateAndTimeStamp.format(new Date()) + " - resource #" + resource.getID() + " updated again");
                    Thread.yield();
                }
                catch (Exception e) {
                    logger.error((Object)"Unable to publish/update the resource ", (Throwable)e);
                    e.printStackTrace();
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
    }
}

