/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.contexts;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.StringWriter;
import org.gcube.common.core.contexts.GCUBEPortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.state.GCUBELocalHome;
import org.gcube.common.core.state.GCUBEPublicationProfile;
import org.gcube.common.core.state.GCUBEWSHome;
import org.gcube.common.core.state.GCUBEWSResourceKey;

public abstract class GCUBEStatefulPortTypeContext
extends GCUBEPortTypeContext {
    protected static final String RPDNAME_JNDI_NAME = "RPDName";
    protected static final String WS_HOME_JNDI_NAME = "home";
    protected static final String RESOURCE_HOME_JNDI_NAME = "localhome";
    protected static final String LIFETIME_JNDI_NAME = "lifeTime";
    protected static final String PUBLICATIONPROFILE_JNDI_NAME = "publicationProfile";
    protected static final String PUBLICATION_MODE_JNDI_PULL = "pull";
    protected static final String PUBLICATION_MODE_JNDI_PUSH = "push";
    protected GCUBEPublicationProfile profile;
    protected boolean publicationStatus = true;

    @Override
    protected void onInitialisation() throws Exception {
        super.onInitialisation();
        this.getLocalHome();
    }

    public String getRPDName() {
        String rpdName = (String)this.getProperty(RPDNAME_JNDI_NAME, false);
        return rpdName == null ? this.getName() + "RPD" : rpdName;
    }

    public GCUBEWSHome getWSHome() {
        return (GCUBEWSHome)this.getProperty(WS_HOME_JNDI_NAME, true);
    }

    public GCUBEWSResourceKey makeKey(String value) {
        return new GCUBEWSResourceKey(this.getWSHome().getKeyTypeName(), value);
    }

    public GCUBELocalHome getLocalHome() {
        return (GCUBELocalHome)this.getProperty(RESOURCE_HOME_JNDI_NAME, new boolean[0]);
    }

    public Integer getResourceLifeTime() {
        try {
            return (Integer)this.getProperty(LIFETIME_JNDI_NAME, new boolean[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public synchronized GCUBEPublicationProfile getPublicationProfile() {
        if (this.profile == null && this.publicationStatus) {
            try {
                String line;
                this.profile = (GCUBEPublicationProfile)this.getProperty(PUBLICATIONPROFILE_JNDI_NAME, new boolean[0]);
                if (this.profile == null) {
                    throw new Exception("configuration was not found.");
                }
                if (!this.profile.getMode().equals(PUBLICATION_MODE_JNDI_PULL) && !this.profile.getMode().equals(PUBLICATION_MODE_JNDI_PUSH)) {
                    throw new Exception("publication mode " + this.profile.getMode() + " is unknown");
                }
                this.profile.setAbsolutePath(GHNContext.getContext().getLocation() + File.separator + (String)this.getServiceContext().getProperty("configDir", new boolean[0]));
                StringWriter writer = new StringWriter();
                BufferedReader reader = new BufferedReader(new FileReader(this.profile.getAbsoluteFileName()));
                while ((line = reader.readLine()) != null) {
                    writer.write(line);
                }
                this.profile.setProfile(writer.toString());
                writer.close();
                reader.close();
            }
            catch (Exception warn) {
                this.logger.warn("Could not configure resource publication because " + warn.getMessage());
                this.publicationStatus = false;
                this.profile = null;
            }
        }
        return this.profile;
    }
}

