/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.resultset.elements;

import org.apache.log4j.Logger;
import org.gcube.common.searchservice.searchlibrary.resultset.ResultSet;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementType;
import org.gcube.common.searchservice.searchlibrary.resultset.helpers.RSFileHelper;

public class KeepTopThreadGeneric
extends Thread {
    private static Logger log = Logger.getLogger(KeepTopThreadGeneric.class);
    public static short PERPART = 0;
    public static short PERRECORD = 1;
    private ResultSet rs = null;
    private ResultSet rsRead = null;
    private int type = PERPART;
    private int count = 0;

    public KeepTopThreadGeneric(ResultSet rs, ResultSet rsRead, int count, int type) {
        this.rs = rs;
        this.count = count;
        this.rsRead = rsRead;
        this.type = type != PERPART && type != PERRECORD ? (int)PERPART : type;
    }

    @Override
    public void run() {
        try {
            int soFar = 0;
            int thisTime = 0;
            do {
                String newFile = null;
                try {
                    newFile = RSFileHelper.generateName((short)0, null);
                    if (this.type == PERPART) {
                        RSFileHelper.copy(this.rsRead.getCurrentContentPartName(), newFile);
                        thisTime = 1;
                    } else {
                        thisTime = this.rsRead.getNumberOfResults(PropertyElementType.XML);
                        if (thisTime + soFar < this.count) {
                            RSFileHelper.copy(this.rsRead.getCurrentContentPartName(), newFile);
                        } else {
                            RSFileHelper.persistContent(newFile, this.rsRead.getRSRef().getResults(), this.count - soFar, this.rsRead.getRSRef().getMnemonic());
                            thisTime = this.count - soFar;
                        }
                        this.rs.getRSRef().clearResults();
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Could not copy current content part. Continuing", (Throwable)e);
                }
                this.rs.wrapFile(newFile);
                this.rs.startNewPart();
            } while ((soFar += thisTime) < this.count && this.rsRead.getNextPart(-1));
            if (this.type == PERRECORD) {
                this.rs.startNewPart();
            }
            this.rs.endAuthoring();
        }
        catch (Exception e) {
            log.error((Object)"Could not end localization procedure.Ending Authoring", (Throwable)e);
            try {
                this.rs.endAuthoring();
            }
            catch (Exception ee) {
                log.error((Object)"Could not end Authoring", (Throwable)ee);
            }
        }
    }
}

