/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mq.leveldb.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.fusesource.leveldbjni.internal.Util;
import org.fusesource.mq.leveldb.util.FileSupport;
import org.fusesource.mq.leveldb.util.Log;
import org.fusesource.mq.leveldb.util.Log$;
import org.fusesource.mq.leveldb.util.ProcessSupport$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileSupport$
implements ScalaObject {
    public static final FileSupport$ MODULE$;
    private final boolean onWindows;
    private int linkStrategy;
    private final Log LOG;

    static {
        new FileSupport$();
    }

    public FileSupport.RichFile toRichFile(File file) {
        return new FileSupport.RichFile(file);
    }

    public boolean onWindows() {
        return this.onWindows;
    }

    private int linkStrategy() {
        return this.linkStrategy;
    }

    private void linkStrategy_$eq(int n) {
        this.linkStrategy = n;
    }

    private Log LOG() {
        return this.LOG;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void link(File source, File target) {
        int n = this.linkStrategy();
        switch (n) {
            default: {
                this.toRichFile(source).copyTo(target);
                return;
            }
            case 0: {
                try {
                    Util.link((File)source, (File)target);
                    return;
                }
                catch (Throwable throwable) {
                    this.LOG().debug((Function0<String>)new Serializable(){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return "Native link system call not available";
                        }
                    }, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    this.linkStrategy_$eq(5);
                    this.link(source, target);
                    return;
                }
                catch (IOException iOException) {
                    throw iOException;
                }
            }
            case 5: {
                try {
                    if (this.onWindows()) {
                        Tuple3<Object, byte[], byte[]> tuple3 = ProcessSupport$.MODULE$.system((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fsutil", "hardlink", "create", target.getCanonicalPath(), source.getCanonicalPath()}));
                        if (tuple3 == null) throw new MatchError(tuple3);
                        if (BoxesRunTime.unboxToInt((Object)tuple3._1()) == 0) return;
                        this.LOG().debug((Function0<String>)new Serializable(){
                            public static final long serialVersionUID;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return "fsutil OS command not available either";
                            }
                        }, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                        this.linkStrategy_$eq(10);
                        this.link(source, target);
                        return;
                    }
                    Tuple3<Object, byte[], byte[]> tuple3 = ProcessSupport$.MODULE$.system((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ln", source.getCanonicalPath(), target.getCanonicalPath()}));
                    if (tuple3 == null) throw new MatchError(tuple3);
                    if (BoxesRunTime.unboxToInt((Object)tuple3._1()) == 0) return;
                    this.LOG().debug((Function0<String>)new Serializable(){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return "ln OS command not available either";
                        }
                    }, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    this.linkStrategy_$eq(2);
                    this.link(source, target);
                    return;
                }
                catch (Throwable throwable) {
                    return;
                }
            }
        }
    }

    public File systemDir(String name) {
        String baseValue = System.getProperty(name);
        if (baseValue == null) {
            throw package$.MODULE$.error(Predef$.MODULE$.augmentString("The the %s system property is not set.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        }
        File file = new File(baseValue);
        if (file.isDirectory()) {
            return file;
        }
        throw package$.MODULE$.error(Predef$.MODULE$.augmentString("The the %s system property is not set to valid directory path %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, baseValue})));
    }

    /*
     * WARNING - void declaration
     */
    public long copy(InputStream in, OutputStream out) {
        void var3_3;
        long bytesCopied = 0L;
        byte[] buffer = new byte[8192];
        int bytes = in.read(buffer);
        while (bytes >= 0) {
            out.write(buffer, 0, bytes);
            bytesCopied += (long)bytes;
            bytes = in.read(buffer);
        }
        return (long)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public <R, C extends Closeable> R using(C closable, Function1<C, R> proc) {
        void var3_3;
        Object exceptionResult1 = null;
        try {
            exceptionResult1 = proc.apply(closable);
        }
        finally {
            try {
                closable.close();
            }
            catch (Throwable throwable) {}
        }
        return var3_3;
    }

    public String readText(InputStream in, String charset) {
        return new String(this.readBytes(in), charset);
    }

    public String readText$default$2() {
        return "UTF-8";
    }

    public byte[] readBytes(InputStream in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.copy(in, out);
        return out.toByteArray();
    }

    public void writeText(OutputStream out, String value, String charset) {
        this.writeBytes(out, value.getBytes(charset));
    }

    public String writeText$default$3() {
        return "UTF-8";
    }

    public void writeBytes(OutputStream out, byte[] data) {
        this.copy(new ByteArrayInputStream(data), out);
    }

    private FileSupport$() {
        MODULE$ = this;
        this.onWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
        this.linkStrategy = 0;
        this.LOG = Log$.MODULE$.apply(this.getClass());
    }
}

