/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.statistics.sampled;

import net.sf.ehcache.statistics.CacheUsageListener;
import net.sf.ehcache.statistics.sampled.NullSampledCacheStatistics;
import net.sf.ehcache.statistics.sampled.SampledCacheStatistics;
import net.sf.ehcache.statistics.sampled.SampledCacheStatisticsImpl;
import net.sf.ehcache.util.FailSafeTimer;

public class SampledCacheStatisticsWrapper
implements CacheUsageListener,
SampledCacheStatistics {
    private static final NullSampledCacheStatistics NULL_SAMPLED_CACHE_STATISTICS = new NullSampledCacheStatistics();
    private volatile SampledCacheStatistics delegate = new NullSampledCacheStatistics();

    public void enableSampledStatistics(FailSafeTimer timer) {
        this.delegate.dispose();
        this.delegate = new SampledCacheStatisticsImpl(timer);
    }

    public void disableSampledStatistics() {
        this.delegate.dispose();
        this.delegate = NULL_SAMPLED_CACHE_STATISTICS;
    }

    public boolean isSampledStatisticsEnabled() {
        return this.delegate instanceof SampledCacheStatisticsImpl;
    }

    public void dispose() {
        this.delegate.dispose();
    }

    public long getAverageGetTimeMostRecentSample() {
        return this.delegate.getAverageGetTimeMostRecentSample();
    }

    public long getCacheElementEvictedMostRecentSample() {
        return this.delegate.getCacheElementEvictedMostRecentSample();
    }

    public long getCacheElementExpiredMostRecentSample() {
        return this.delegate.getCacheElementExpiredMostRecentSample();
    }

    public long getCacheElementPutMostRecentSample() {
        return this.delegate.getCacheElementPutMostRecentSample();
    }

    public long getCacheElementRemovedMostRecentSample() {
        return this.delegate.getCacheElementRemovedMostRecentSample();
    }

    public long getCacheElementUpdatedMostRecentSample() {
        return this.delegate.getCacheElementUpdatedMostRecentSample();
    }

    public long getCacheHitInMemoryMostRecentSample() {
        return this.delegate.getCacheHitInMemoryMostRecentSample();
    }

    public long getCacheHitOffHeapMostRecentSample() {
        return this.delegate.getCacheHitOffHeapMostRecentSample();
    }

    public long getCacheHitMostRecentSample() {
        return this.delegate.getCacheHitMostRecentSample();
    }

    public long getCacheHitOnDiskMostRecentSample() {
        return this.delegate.getCacheHitOnDiskMostRecentSample();
    }

    public long getCacheMissExpiredMostRecentSample() {
        return this.delegate.getCacheMissExpiredMostRecentSample();
    }

    public long getCacheMissMostRecentSample() {
        return this.delegate.getCacheMissMostRecentSample();
    }

    public long getCacheMissInMemoryMostRecentSample() {
        return this.delegate.getCacheMissInMemoryMostRecentSample();
    }

    public long getCacheMissOffHeapMostRecentSample() {
        return this.delegate.getCacheMissOffHeapMostRecentSample();
    }

    public long getCacheMissOnDiskMostRecentSample() {
        return this.delegate.getCacheMissOnDiskMostRecentSample();
    }

    public long getCacheMissNotFoundMostRecentSample() {
        return this.delegate.getCacheMissNotFoundMostRecentSample();
    }

    public int getStatisticsAccuracy() {
        return this.delegate.getStatisticsAccuracy();
    }

    public void clearStatistics() {
        this.delegate.clearStatistics();
    }

    public String getStatisticsAccuracyDescription() {
        return this.delegate.getStatisticsAccuracyDescription();
    }

    private CacheUsageListener getDelegateAsListener() {
        return (CacheUsageListener)((Object)this.delegate);
    }

    public void notifyCacheElementEvicted() {
        this.getDelegateAsListener().notifyCacheElementEvicted();
    }

    public void notifyCacheElementExpired() {
        this.getDelegateAsListener().notifyCacheElementExpired();
    }

    public void notifyCacheElementPut() {
        this.getDelegateAsListener().notifyCacheElementPut();
    }

    public void notifyCacheElementRemoved() {
        this.getDelegateAsListener().notifyCacheElementRemoved();
    }

    public void notifyCacheElementUpdated() {
        this.getDelegateAsListener().notifyCacheElementUpdated();
    }

    public void notifyCacheHitInMemory() {
        this.getDelegateAsListener().notifyCacheHitInMemory();
    }

    public void notifyCacheHitOffHeap() {
        this.getDelegateAsListener().notifyCacheHitOffHeap();
    }

    public void notifyCacheHitOnDisk() {
        this.getDelegateAsListener().notifyCacheHitOnDisk();
    }

    public void notifyCacheMissedWithExpired() {
        this.getDelegateAsListener().notifyCacheMissedWithExpired();
    }

    public void notifyCacheMissedWithNotFound() {
        this.getDelegateAsListener().notifyCacheMissedWithNotFound();
    }

    public void notifyCacheMissInMemory() {
        this.getDelegateAsListener().notifyCacheMissInMemory();
    }

    public void notifyCacheMissOffHeap() {
        this.getDelegateAsListener().notifyCacheMissOffHeap();
    }

    public void notifyCacheMissOnDisk() {
        this.getDelegateAsListener().notifyCacheMissOnDisk();
    }

    public void notifyRemoveAll() {
        this.getDelegateAsListener().notifyRemoveAll();
    }

    public void notifyStatisticsAccuracyChanged(int statisticsAccuracy) {
        this.getDelegateAsListener().notifyStatisticsAccuracyChanged(statisticsAccuracy);
    }

    public void notifyStatisticsCleared() {
        this.getDelegateAsListener().notifyStatisticsCleared();
    }

    public void notifyStatisticsEnabledChanged(boolean enableStatistics) {
        this.getDelegateAsListener().notifyStatisticsEnabledChanged(enableStatistics);
    }

    public void notifyTimeTakenForGet(long millis) {
        this.getDelegateAsListener().notifyTimeTakenForGet(millis);
    }

    public long getAverageSearchTime() {
        return this.delegate.getAverageSearchTime();
    }

    public long getSearchesPerSecond() {
        return this.delegate.getSearchesPerSecond();
    }

    public void notifyCacheSearch(long executeTime) {
        this.getDelegateAsListener().notifyCacheSearch(executeTime);
    }

    public void notifyXaCommit() {
        this.getDelegateAsListener().notifyXaCommit();
    }

    public void notifyXaRollback() {
        this.getDelegateAsListener().notifyXaRollback();
    }

    public long getCacheXaCommitsMostRecentSample() {
        return this.delegate.getCacheXaCommitsMostRecentSample();
    }

    public long getCacheXaRollbacksMostRecentSample() {
        return this.delegate.getCacheXaRollbacksMostRecentSample();
    }
}

