/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.utils;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Calendar;
import org.apache.axis.Constants;
import org.apache.axis.types.URI;
import org.apache.axis.utils.JavaUtils;
import org.globus.util.I18n;
import org.globus.wsrf.utils.AnyHelper;
import org.globus.wsrf.utils.Resources;
import org.oasis.wsrf.faults.BaseFaultType;
import org.oasis.wsrf.faults.BaseFaultTypeDescription;
import org.oasis.wsrf.faults.BaseFaultTypeErrorCode;
import org.w3c.dom.Element;

public class FaultHelper {
    private static final String LS = System.getProperty("line.separator");
    public static final URI STACK_TRACE;
    public static final URI EXCEPTION;
    private static I18n i18n;
    private BaseFaultType fault;

    public FaultHelper(BaseFaultType fault) {
        this(fault, true);
    }

    public FaultHelper(BaseFaultType fault, boolean convertStackTrace) {
        if (fault == null) {
            throw new IllegalArgumentException(i18n.getMessage("nullArgument", (Object)"fault"));
        }
        this.fault = fault;
        if (convertStackTrace) {
            this.addStackTraceFault();
        }
        if (this.fault.getTimestamp() == null) {
            this.fault.setTimestamp(Calendar.getInstance());
        }
    }

    public BaseFaultType getFault() {
        return this.fault;
    }

    public String getDescriptionAsString() {
        BaseFaultTypeDescription[] desc = this.fault.getDescription();
        if (desc == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < desc.length; ++i) {
            buf.append(desc[i].get_value());
            if (i + 1 >= desc.length) continue;
            buf.append(" / ");
        }
        return buf.toString();
    }

    public String[] getDescription() {
        BaseFaultTypeDescription[] desc = this.fault.getDescription();
        if (desc == null) {
            return null;
        }
        String[] description = new String[desc.length];
        for (int i = 0; i < description.length; ++i) {
            description[i] = desc[i].get_value();
        }
        return description;
    }

    public void setDescription(String description) {
        String[] stringArray;
        if (description == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = description;
        }
        this.setDescription(stringArray);
    }

    public void setDescription(String[] description) {
        BaseFaultTypeDescription[] desc = null;
        if (description != null) {
            desc = new BaseFaultTypeDescription[description.length];
            for (int i = 0; i < description.length; ++i) {
                desc[i] = new BaseFaultTypeDescription(description[i]);
            }
        }
        this.fault.setDescription(desc);
    }

    public void addDescription(String description) {
        if (description == null) {
            throw new IllegalArgumentException(i18n.getMessage("nullArgument", (Object)"description"));
        }
        BaseFaultTypeDescription[] desc = this.fault.getDescription();
        BaseFaultTypeDescription[] newDesc = null;
        if (desc == null) {
            newDesc = new BaseFaultTypeDescription[1];
        } else {
            newDesc = new BaseFaultTypeDescription[desc.length + 1];
            System.arraycopy(desc, 0, newDesc, 0, desc.length);
        }
        newDesc[newDesc.length - 1] = new BaseFaultTypeDescription(description);
        this.fault.setDescription(newDesc);
    }

    public void addFaultCause(Throwable exception) {
        this.addFaultCause(FaultHelper.toBaseFault(exception));
    }

    private void addFaultCause(BaseFaultType fault) {
        BaseFaultType[] cause = this.fault.getFaultCause();
        BaseFaultType[] newCause = null;
        if (cause == null) {
            newCause = new BaseFaultType[1];
        } else {
            newCause = new BaseFaultType[cause.length + 1];
            System.arraycopy(cause, 0, newCause, 0, cause.length);
        }
        newCause[newCause.length - 1] = fault;
        this.fault.setFaultCause(newCause);
    }

    private void addStackTraceFault() {
        Element stackElement = this.fault.lookupFaultDetail(Constants.QNAME_FAULTDETAIL_STACKTRACE);
        if (stackElement == null) {
            return;
        }
        this.fault.removeFaultDetail(Constants.QNAME_FAULTDETAIL_STACKTRACE);
        String message = this.fault.getClass().getName();
        String stackTrace = stackElement.getFirstChild().getNodeValue();
        this.addFaultCause(FaultHelper.createStackFault(message, stackTrace));
    }

    private void addStackTraceFault(Throwable exception) {
        String message = exception.getClass().getName();
        String stackTrace = JavaUtils.stackToString((Throwable)exception);
        this.addFaultCause(FaultHelper.createStackFault(message, stackTrace));
    }

    private static BaseFaultType createStackFault(String message, String stackTrace) {
        BaseFaultType stackFault = new BaseFaultType();
        BaseFaultTypeErrorCode errorCode = new BaseFaultTypeErrorCode();
        errorCode.setDialect(STACK_TRACE);
        errorCode.set_any(AnyHelper.toText(stackTrace));
        stackFault.setErrorCode(errorCode);
        if (message != null && message.length() > 0) {
            BaseFaultTypeDescription[] desc = new BaseFaultTypeDescription[]{new BaseFaultTypeDescription(message)};
            stackFault.setDescription(desc);
        }
        stackFault.setTimestamp(Calendar.getInstance());
        return stackFault;
    }

    public static BaseFaultType toBaseFault(Throwable exception) {
        BaseFaultType fault = null;
        if (exception instanceof BaseFaultType) {
            fault = (BaseFaultType)exception;
            FaultHelper helper = new FaultHelper(fault, false);
            helper.addStackTraceFault();
        } else {
            fault = new BaseFaultType();
            FaultHelper helper = new FaultHelper(fault, false);
            helper.setDescription(exception.getMessage());
            helper.addStackTraceFault(exception);
        }
        return fault;
    }

    public static String getMessage(Throwable exception) {
        if (exception instanceof BaseFaultType) {
            FaultHelper faultHelper = new FaultHelper((BaseFaultType)exception, false);
            return faultHelper.getMessage();
        }
        return exception.getMessage();
    }

    public static void printStackTrace(Throwable exception) {
        if (exception instanceof BaseFaultType) {
            exception.printStackTrace();
        } else {
            exception.printStackTrace();
        }
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream s) {
        s.println(this.getStackTrace());
    }

    public void printStackTrace(PrintWriter s) {
        s.println(this.getStackTrace());
    }

    public String getMessage() {
        BaseFaultType[] cause;
        BaseFaultTypeErrorCode errorCode = this.fault.getErrorCode();
        if (errorCode != null && STACK_TRACE.equals((Object)errorCode.getDialect())) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.fault.getClass().getName());
        String desc = this.getDescriptionAsString();
        if (desc != null) {
            buf.append(": ").append(desc);
        }
        if ((cause = this.fault.getFaultCause()) != null) {
            boolean wroteCauseBy = false;
            int j = 0;
            for (int i = 0; i < cause.length; ++i) {
                desc = FaultHelper.getMessage((Throwable)cause[i]);
                if (desc == null) continue;
                if (!wroteCauseBy) {
                    buf.append(i18n.getMessage("causedBy") + "[");
                    wroteCauseBy = true;
                }
                buf.append(String.valueOf(j++)).append(": ").append(desc);
            }
            if (wroteCauseBy) {
                buf.append("]");
            }
        }
        return buf.toString();
    }

    public String getStackTrace() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.fault.getClass().getName());
        String desc = this.getDescriptionAsString();
        if (desc != null) {
            buf.append(": ").append(desc);
        }
        if (this.fault.getTimestamp() != null) {
            buf.append(LS).append(i18n.getMessage("timestamp"));
            buf.append(this.fault.getTimestamp().getTime().toString());
        }
        if (this.fault.getOriginator() != null) {
            buf.append(LS).append(i18n.getMessage("originator"));
            buf.append(this.fault.getOriginator().toString());
        }
        BaseFaultType[] cause = this.fault.getFaultCause();
        BaseFaultTypeErrorCode errorCode = null;
        if (cause != null) {
            FaultHelper helper = null;
            for (int i = 0; i < cause.length; ++i) {
                helper = new FaultHelper(cause[i], false);
                errorCode = cause[i].getErrorCode();
                if (errorCode != null && STACK_TRACE.equals((Object)errorCode.getDialect())) {
                    buf.append(LS);
                    try {
                        buf.append(AnyHelper.toSingleString(errorCode.get_any()));
                    }
                    catch (Exception e) {}
                    continue;
                }
                buf.append(LS).append(i18n.getMessage("causedBy01"));
                buf.append(helper.getStackTrace());
            }
        }
        return buf.toString();
    }

    static {
        i18n = I18n.getI18n((String)Resources.class.getName());
        try {
            STACK_TRACE = new URI("http://www.globus.org/fault/stacktrace");
            EXCEPTION = new URI("http://www.globus.org/fault/exception");
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

