/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.utils;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.soap.SOAPElement;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.AnyContentType;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.Text;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.wsrf.config.ContainerConfig;
import org.globus.wsrf.utils.XmlUtils;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class AnyHelper {
    static Log logger = LogFactory.getLog((String)AnyHelper.class.getName());

    public static MessageElement[] toText(Object obj) {
        MessageElement[] result = new MessageElement[]{new MessageElement((CharacterData)new Text(obj.toString()))};
        return result;
    }

    public static MessageElement[] toAnyArray(Object[] obj) {
        MessageElement[] result = new MessageElement[obj.length];
        for (int i = 0; i < obj.length; ++i) {
            result[i] = AnyHelper.toAny(obj[i]);
        }
        return result;
    }

    public static MessageElement[] toAnyArray(Object obj) {
        MessageElement[] result = new MessageElement[]{AnyHelper.toAny(obj)};
        return result;
    }

    public static MessageElement[] toAnyArray(Element element) {
        MessageElement[] result = new MessageElement[]{new MessageElement(element)};
        return result;
    }

    public static MessageElement toAnyTypeElement(Object obj) {
        MessageElement messageElement = new MessageElement("http://www.globus.org/namespaces/2004/06/core", "value", obj);
        messageElement.setType(Constants.XSD_ANYTYPE);
        return messageElement;
    }

    public static MessageElement toAny(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof MessageElement) {
            return (MessageElement)obj;
        }
        if (obj instanceof Element) {
            return new MessageElement((Element)obj);
        }
        return AnyHelper.toAnyTypeElement(obj);
    }

    public static MessageElement getParent(MessageElement element) {
        return element == null ? null : (MessageElement)element.getParentElement();
    }

    public static MessageElement getParent(MessageElement[] elements) {
        return elements != null && elements.length > 0 ? AnyHelper.getParent(elements[0]) : null;
    }

    public static MessageElement getParent(AnyContentType any) {
        return any != null ? AnyHelper.getParent(any.get_any()) : null;
    }

    public static void setAny(AnyContentType object, SOAPElement value) {
        if (value == null || object == null) {
            return;
        }
        if (!(value instanceof MessageElement)) {
            throw new IllegalArgumentException();
        }
        object.set_any(new MessageElement[]{(MessageElement)value});
    }

    public static void setAny(AnyContentType object, SOAPElement[] values) {
        if (values == null || object == null) {
            return;
        }
        MessageElement[] me = null;
        if (values instanceof MessageElement[]) {
            me = (MessageElement[])values;
        } else {
            me = new MessageElement[values.length];
            for (int i = 0; i < values.length; ++i) {
                if (!(values[i] instanceof MessageElement)) {
                    throw new IllegalArgumentException();
                }
                me[i] = (MessageElement)values[i];
            }
        }
        object.set_any(me);
    }

    public static void setAny(AnyContentType object, List values) {
        if (values == null) {
            return;
        }
        MessageElement[] v = new MessageElement[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            Object obj = values.get(i);
            if (!(obj instanceof MessageElement)) {
                throw new IllegalArgumentException();
            }
            v[i] = (MessageElement)obj;
        }
        object.set_any(v);
    }

    public static void write(Writer writer, MessageElement element) throws Exception {
        MessageContext messageContext = ContainerConfig.getContext();
        SerializationContext context = new SerializationContext(writer, messageContext);
        context.setPretty(true);
        element.output(context);
        writer.write(10);
    }

    public static String toString(MessageElement element) throws Exception {
        if (element == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        AnyHelper.write(writer, element);
        writer.flush();
        return writer.toString();
    }

    public static String[] toString(MessageElement[] elements) throws Exception {
        if (elements == null) {
            return null;
        }
        String[] result = new String[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            result[i] = AnyHelper.toString(elements[i]);
        }
        return result;
    }

    public static String toSingleString(MessageElement[] elements) throws Exception {
        if (elements == null) {
            return null;
        }
        MessageContext messageContext = ContainerConfig.getContext();
        StringWriter writer = new StringWriter();
        SerializationContext context = new SerializationContext((Writer)writer, messageContext);
        context.setPretty(true);
        for (int i = 0; i < elements.length; ++i) {
            elements[i].output(context);
        }
        writer.flush();
        return writer.toString();
    }

    public static String toSingleString(AnyContentType any) throws Exception {
        return any == null ? null : AnyHelper.toSingleString(any.get_any());
    }

    public static String getFirstParentAsString(AnyContentType any) throws Exception {
        return AnyHelper.toString(AnyHelper.getParent(any));
    }

    public static Element toElement(MessageElement element) throws Exception {
        String str = AnyHelper.toString(element);
        if (str == null) {
            return null;
        }
        StringReader reader = new StringReader(str);
        Document doc = XmlUtils.newDocument(new InputSource(reader));
        return doc == null ? null : doc.getDocumentElement();
    }

    public static Element[] toElement(MessageElement[] elements) throws Exception {
        if (elements == null) {
            return null;
        }
        Element[] result = new Element[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            result[i] = AnyHelper.toElement(elements[i]);
        }
        return result;
    }

    public static Element[] toElement(AnyContentType any) throws Exception {
        if (any == null) {
            return null;
        }
        return AnyHelper.toElement(any.get_any());
    }

    public static Element getFirstParentAsElement(AnyContentType any) throws Exception {
        return AnyHelper.toElement(AnyHelper.getParent(any));
    }

    public static Element getFirstAsElement(AnyContentType any) throws Exception {
        Element[] values = AnyHelper.toElement(any);
        return values != null && values.length > 0 ? values[0] : null;
    }
}

