/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.utils.logging;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.common.core.contexts.GCUBEContext;

public class GCUBELog {
    private volatile Log logger;
    private String prefix;
    private GCUBEContext ctxt;

    public GCUBELog(Object obj, GCUBEContext context) {
        this(obj);
        this.setContext(context);
    }

    public GCUBELog(Object obj, String prefix) {
        this(obj);
        this.setPrefix(prefix);
    }

    public GCUBELog(Object obj) {
        try {
            Class clazz = (Class)obj;
            this.logger = LogFactory.getLog((Class)clazz);
            this.setPrefix(clazz.getSimpleName());
        }
        catch (ClassCastException e) {
            this.logger = LogFactory.getLog(obj.getClass());
            this.setPrefix(obj.getClass().getSimpleName());
        }
    }

    public void debug(Object arg0) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.getPrefix() + arg0));
        }
    }

    public void debug(Object arg0, Throwable arg1) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.getPrefix() + arg0), arg1);
        }
    }

    public void error(Object arg0) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error((Object)(this.getPrefix() + arg0));
        }
    }

    public void error(Object arg0, Throwable arg1) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error((Object)(this.getPrefix() + arg0), arg1);
        }
    }

    public void fatal(Object arg0) {
        if (this.logger.isFatalEnabled()) {
            this.logger.fatal((Object)(this.getPrefix() + arg0));
        }
    }

    public void fatal(Object arg0, Throwable arg1) {
        if (this.logger.isFatalEnabled()) {
            this.logger.fatal((Object)(this.getPrefix() + arg0), arg1);
        }
    }

    public void info(Object arg0) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)(this.getPrefix() + arg0));
        }
    }

    public void info(Object arg0, Throwable arg1) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)(this.getPrefix() + arg0), arg1);
        }
    }

    public void trace(Object arg0) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.getPrefix() + arg0));
        }
    }

    public void trace(Object arg0, Throwable arg1) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.getPrefix() + arg0), arg1);
        }
    }

    public void warn(Object arg0) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)(this.getPrefix() + arg0));
        }
    }

    public void warn(Object arg0, Throwable arg1) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)(this.getPrefix() + arg0), arg1);
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.logger.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public String getPrefix() {
        return (this.ctxt == null ? "" : "[" + this.ctxt.getTiming() + "s] ") + this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix + ": ";
    }

    public synchronized void setContext(GCUBEContext context) {
        this.setPrefix(context.getName());
        this.ctxt = context;
    }
}

