/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.resultset.elements;

import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.log4j.Logger;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.StreamWorker;

public class StreamManager
extends Thread {
    private static Logger log = Logger.getLogger(StreamManager.class);
    private int port = 0;
    private boolean SSLsupport = true;

    public StreamManager(int port, boolean SSLsupport) {
        log.trace((Object)("Stream Manager created and listenning on port " + port));
        this.port = port;
        this.SSLsupport = SSLsupport;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void run() {
        try {
            ServerSocket sock = this.getServeSocket();
            while (true) {
                try {
                    while (true) {
                        Socket skt = sock.accept();
                        StreamWorker worker = new StreamWorker(skt);
                        worker.start();
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Could not initialize worker. continuing", (Throwable)e);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not initialite socket. FATAL ERROR", (Throwable)e);
            return;
        }
    }

    private ServerSocket getServeSocket() throws Exception {
        ServerSocket socket = null;
        if (this.SSLsupport) {
            SSLServerSocketFactory sslserversocketfactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
            log.info((Object)("Port for secure stream manager to listen to: " + this.port));
            SSLServerSocket sslserversocket = (SSLServerSocket)sslserversocketfactory.createServerSocket(this.port);
            String[] enable = new String[]{"TLS_DH_anon_WITH_AES_128_CBC_SHA"};
            sslserversocket.setEnabledCipherSuites(enable);
            log.debug((Object)("Availuable chifer suits" + sslserversocket.getEnabledCipherSuites()));
            for (int i = 0; i < sslserversocket.getEnabledCipherSuites().length; ++i) {
                log.debug((Object)sslserversocket.getEnabledCipherSuites()[i]);
            }
            socket = sslserversocket;
        } else {
            log.info((Object)("Port for non secure stream manager to listen to: " + this.port));
            socket = new ServerSocket(this.port);
        }
        return socket;
    }
}

