/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.notification.impl.client;

import javax.xml.namespace.QName;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.utils.events.GCUBEEvent;
import org.gcube.common.core.utils.logging.GCUBELog;

class Notifier
implements Runnable {
    protected static final GCUBELog log = new GCUBELog(Notifier.class);
    private QName topic;
    private EndpointReferenceType epr;
    private ISNotifier.BaseNotificationConsumer receiver;
    private MessageElement[] message;

    public Notifier(QName qName, EndpointReferenceType endpointReferenceType, ISNotifier.BaseNotificationConsumer baseNotificationConsumer, MessageElement[] messageElementArray) {
        this.topic = qName;
        this.epr = endpointReferenceType;
        this.receiver = baseNotificationConsumer;
        this.message = messageElementArray;
    }

    public void run() {
        log.info((Object)("Notifying subscriber about " + this.topic + " from " + this.epr.getAddress()));
        try {
            GCUBEEvent gCUBEEvent = new GCUBEEvent();
            gCUBEEvent.setPayload((Object)new ISNotifier.NotificationMessage(this.topic, this.message, this.epr));
            this.receiver.onEvent(new GCUBEEvent[]{gCUBEEvent});
        }
        catch (Throwable throwable) {
            log.error((Object)"Error while notifying subscriber", throwable);
        }
    }
}

