/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.persistence;

import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.gcube.common.core.persistence.GCUBEFilePersistenceDelegate;
import org.gcube.common.core.state.GCUBELocalResource;
import org.gcube.common.core.state.GCUBEResourceHome;
import org.gcube.common.core.state.GCUBEStatefulResource;

public class GCUBELRFilePersistenceDelegate<RESOURCE extends GCUBELocalResource>
extends GCUBEFilePersistenceDelegate<String, RESOURCE> {
    protected static final String LOCAL_FILE_SUFFIX = ".local";

    @Override
    public void initialise(GCUBEResourceHome<? super String, String, RESOURCE> home) throws Exception {
        super.initialise(home);
        Class<?> resourceClass = this.getClass().getClassLoader().loadClass(home.getResourceClass());
        if (!GCUBELocalResource.class.isAssignableFrom(resourceClass)) {
            throw new Exception(home.getResourceClass() + " is not compatible with delegate " + this.getClass().getSimpleName());
        }
    }

    @Override
    protected File getFileFromResource(RESOURCE resource) {
        return new File(this.getStorageRoot(), (String)((GCUBEStatefulResource)resource).getID() + this.getSuffix());
    }

    @Override
    protected void onLoad(RESOURCE resource, ObjectInputStream stream) throws Exception {
        ((GCUBELocalResource)resource).setLinks(stream.readInt());
    }

    @Override
    protected void onStore(RESOURCE resource, ObjectOutputStream stream) throws Exception {
        stream.writeInt(((GCUBELocalResource)resource).getLinks());
    }

    @Override
    protected String getSuffix() {
        return LOCAL_FILE_SUFFIX;
    }

    @Override
    protected String getIDFromFileName(String s) {
        return s;
    }
}

