/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.AlgorithmAlreadyRegisteredException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.InvalidTransformException;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.utils.HelperNodeList;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class Transform
extends SignatureElementProxy {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$transforms$Transform == null ? (class$org$apache$xml$security$transforms$Transform = Transform.class$("org.apache.xml.security.transforms.Transform")) : class$org$apache$xml$security$transforms$Transform).getName());
    static boolean _alreadyInitialized = false;
    static HashMap _transformHash = null;
    protected TransformSpi transformSpi = null;
    static /* synthetic */ Class class$org$apache$xml$security$transforms$Transform;

    public Transform(Document document, String string, NodeList nodeList) throws InvalidTransformException {
        super(document);
        try {
            this._constructionElement.setAttributeNS(null, "Algorithm", string);
            String string2 = Transform.getImplementingClass(string);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Create URI \"" + string + "\" class \"" + string2 + "\""));
                log.debug((Object)("The NodeList is " + nodeList));
            }
            this.transformSpi = (TransformSpi)Class.forName(string2).newInstance();
            this.transformSpi.setTransform(this);
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    this._constructionElement.appendChild(nodeList.item(i).cloneNode(true));
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object[] objectArray = new Object[]{string};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray, classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Object[] objectArray = new Object[]{string};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            Object[] objectArray = new Object[]{string};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray, instantiationException);
        }
    }

    public Transform(Element element, String string) throws InvalidTransformException, TransformationException, XMLSecurityException {
        super(element, string);
        String string2 = element.getAttributeNS(null, "Algorithm");
        if (string2 == null || string2.length() == 0) {
            Object[] objectArray = new Object[]{"Algorithm", "Transform"};
            throw new TransformationException("xml.WrongContent", objectArray);
        }
        try {
            String string3 = (String)_transformHash.get(string2);
            this.transformSpi = (TransformSpi)Class.forName(string3).newInstance();
            this.transformSpi.setTransform(this);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object[] objectArray = new Object[]{string2};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            Object[] objectArray = new Object[]{string2};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray);
        }
        catch (InstantiationException instantiationException) {
            Object[] objectArray = new Object[]{string2};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray);
        }
    }

    public static final Transform getInstance(Document document, String string) throws InvalidTransformException {
        return Transform.getInstance(document, string, (NodeList)null);
    }

    public static final Transform getInstance(Document document, String string, Element element) throws InvalidTransformException {
        HelperNodeList helperNodeList = new HelperNodeList();
        helperNodeList.appendChild(document.createTextNode("\n"));
        helperNodeList.appendChild(element);
        helperNodeList.appendChild(document.createTextNode("\n"));
        return Transform.getInstance(document, string, helperNodeList);
    }

    public static final Transform getInstance(Document document, String string, NodeList nodeList) throws InvalidTransformException {
        return new Transform(document, string, nodeList);
    }

    public static void init() {
        if (!_alreadyInitialized) {
            _transformHash = new HashMap(10);
            _alreadyInitialized = true;
        }
    }

    public static void register(String string, String string2) throws AlgorithmAlreadyRegisteredException {
        String string3 = Transform.getImplementingClass(string);
        if (string3 != null && string3.length() != 0) {
            Object[] objectArray = new Object[]{string, string3};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", objectArray);
        }
        _transformHash.put(string, string2);
    }

    public final String getURI() {
        return this._constructionElement.getAttributeNS(null, "Algorithm");
    }

    public XMLSignatureInput performTransform(XMLSignatureInput xMLSignatureInput) throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException {
        XMLSignatureInput xMLSignatureInput2 = null;
        try {
            xMLSignatureInput2 = this.transformSpi.enginePerformTransform(xMLSignatureInput);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Object[] objectArray = new Object[]{this.getURI(), "ParserConfigurationException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", objectArray, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            Object[] objectArray = new Object[]{this.getURI(), "SAXException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", objectArray, sAXException);
        }
        return xMLSignatureInput2;
    }

    public XMLSignatureInput performTransform(XMLSignatureInput xMLSignatureInput, OutputStream outputStream) throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException {
        XMLSignatureInput xMLSignatureInput2 = null;
        try {
            xMLSignatureInput2 = this.transformSpi.enginePerformTransform(xMLSignatureInput, outputStream);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Object[] objectArray = new Object[]{this.getURI(), "ParserConfigurationException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", objectArray, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            Object[] objectArray = new Object[]{this.getURI(), "SAXException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", objectArray, sAXException);
        }
        return xMLSignatureInput2;
    }

    private static String getImplementingClass(String string) {
        try {
            Iterator iterator = _transformHash.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!string2.equals(string)) continue;
                return (String)_transformHash.get(string2);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public String getBaseLocalName() {
        return "Transform";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

