/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.channel.registry;

import gr.uoa.di.madgik.commons.channel.events.ChannelState;
import gr.uoa.di.madgik.commons.channel.nozzle.INozzleConfig;
import gr.uoa.di.madgik.commons.channel.proxy.IChannelProxy;
import gr.uoa.di.madgik.commons.channel.registry.ChannelRegistryKey;
import gr.uoa.di.madgik.commons.channel.registry.RegisteredNozzle;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChannelRegistryEntry {
    private static Logger logger = Logger.getLogger(ChannelRegistryEntry.class.getName());
    private final Object synchNozzles = new Object();
    private ChannelRegistryKey Key = null;
    private ChannelState State = null;
    private String InletNozzleID = null;
    private List<RegisteredNozzle> Nozzles = null;
    private INozzleConfig Config = null;

    public ChannelRegistryEntry(ChannelRegistryKey Key, ChannelState State2, INozzleConfig Config, String RegisteringNozzle) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Creating new registry entry for key " + Key.toString());
        }
        this.Key = Key;
        this.State = State2;
        this.Config = Config;
        this.Nozzles = new ArrayList<RegisteredNozzle>();
        this.InletNozzleID = RegisteringNozzle;
    }

    public ChannelRegistryKey GetRegistryKey() {
        return this.Key;
    }

    public String GetInletNozzleID() {
        return this.InletNozzleID;
    }

    public ChannelState GetState() {
        return this.State;
    }

    public IChannelProxy GetProxy() {
        return this.Config.GetChannelProxy();
    }

    public boolean GetIsBroadcast() {
        return this.Config.GetIsBroadcast();
    }

    public INozzleConfig GetConfig() {
        return this.Config;
    }

    public int GetRestrictBroadcast() {
        return this.Config.GetRestrictBroadcast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean RegisterNozzle(RegisteredNozzle entry) {
        Object object = this.synchNozzles;
        synchronized (object) {
            int nozzleCount = this.Nozzles.size();
            if (nozzleCount == 0) {
                this.Nozzles.add(entry);
                return true;
            }
            if (!this.GetIsBroadcast()) {
                return false;
            }
            if (this.GetRestrictBroadcast() <= 0) {
                this.Nozzles.add(entry);
                return true;
            }
            if (this.GetRestrictBroadcast() > 0 && this.GetRestrictBroadcast() <= nozzleCount) {
                return false;
            }
            this.Nozzles.add(entry);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean HasConnected() {
        Object object = this.synchNozzles;
        synchronized (object) {
            return this.Nozzles.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean StillConnected() {
        Object object = this.synchNozzles;
        synchronized (object) {
            for (RegisteredNozzle rn : this.Nozzles) {
                if (!rn.GetIsConnected().booleanValue()) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RegisteredNozzle> GetRegisteredNozzles() {
        Object object = this.synchNozzles;
        synchronized (object) {
            ArrayList<RegisteredNozzle> ret = new ArrayList<RegisteredNozzle>();
            for (RegisteredNozzle rn : this.Nozzles) {
                ret.add(rn);
            }
            return ret;
        }
    }

    public void Dispose() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Disposing registry entry for registry key " + this.Key.toString());
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Disposing chanel state for registry key " + this.Key.toString());
        }
        this.State.Dispose();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Disposing chanel inlet config for registry key " + this.Key.toString());
        }
        this.Config.Dispose();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Disposing registered Nozzles for registry key " + this.Key.toString());
        }
        for (RegisteredNozzle noz : this.Nozzles) {
            noz.Dispose();
        }
        this.Nozzles.clear();
    }
}

