/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.filter;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.jms.JMSException;
import org.apache.activemq.command.Message;
import org.apache.activemq.filter.BooleanExpression;
import org.apache.activemq.filter.ConstantExpression;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.filter.XalanXPathEvaluator;
import org.apache.activemq.util.JMSExceptionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class XPathExpression
implements BooleanExpression {
    private static final Log LOG = LogFactory.getLog(XPathExpression.class);
    private static final String EVALUATOR_SYSTEM_PROPERTY = "org.apache.activemq.XPathEvaluatorClassName";
    private static final String DEFAULT_EVALUATOR_CLASS_NAME = XalanXPathEvaluator.class.getName();
    private static final Constructor EVALUATOR_CONSTRUCTOR;
    private final String xpath;
    private final XPathEvaluator evaluator;

    XPathExpression(String xpath) {
        this.xpath = xpath;
        this.evaluator = this.createEvaluator(xpath);
    }

    private static Constructor getXPathEvaluatorConstructor(String cn) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        Class<?> c = XPathExpression.class.getClassLoader().loadClass(cn);
        if (!XPathEvaluator.class.isAssignableFrom(c)) {
            throw new ClassCastException("" + c + " is not an instance of " + XPathEvaluator.class);
        }
        return c.getConstructor(String.class);
    }

    private XPathEvaluator createEvaluator(String xpath2) {
        try {
            return (XPathEvaluator)EVALUATOR_CONSTRUCTOR.newInstance(this.xpath);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException("Invalid XPath Expression: " + this.xpath + " reason: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            throw new RuntimeException("Invalid XPath Expression: " + this.xpath + " reason: " + e.getMessage(), e);
        }
    }

    public Object evaluate(MessageEvaluationContext message) throws JMSException {
        try {
            if (message.isDropped()) {
                return null;
            }
            return this.evaluator.evaluate(message.getMessage()) ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (IOException e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    public String toString() {
        return "XPATH " + ConstantExpression.encodeString(this.xpath);
    }

    public boolean matches(MessageEvaluationContext message) throws JMSException {
        Object object = this.evaluate(message);
        return object != null && object == Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String cn = System.getProperty(EVALUATOR_SYSTEM_PROPERTY, DEFAULT_EVALUATOR_CLASS_NAME);
        Constructor m = null;
        try {
            try {
                m = XPathExpression.getXPathEvaluatorConstructor(cn);
            }
            catch (Throwable e) {
                LOG.warn((Object)("Invalid " + XPathEvaluator.class.getName() + " implementation: " + cn + ", reason: " + e), e);
                cn = DEFAULT_EVALUATOR_CLASS_NAME;
                try {
                    m = XPathExpression.getXPathEvaluatorConstructor(cn);
                }
                catch (Throwable e2) {
                    LOG.error((Object)"Default XPath evaluator could not be loaded", e);
                }
            }
        }
        finally {
            EVALUATOR_CONSTRUCTOR = m;
        }
    }

    public static interface XPathEvaluator {
        public boolean evaluate(Message var1) throws JMSException;
    }
}

