/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.data;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.StoreLocation;
import org.apache.activemq.kaha.impl.data.DataItem;
import org.apache.activemq.kaha.impl.data.DataManagerImpl;
import org.apache.activemq.util.DataByteArrayInputStream;

public final class SyncDataFileReader {
    private DataManagerImpl dataManager;
    private DataByteArrayInputStream dataIn;

    SyncDataFileReader(DataManagerImpl fileManager) {
        this.dataManager = fileManager;
        this.dataIn = new DataByteArrayInputStream();
    }

    public synchronized byte readDataItemSize(DataItem item) throws IOException {
        RandomAccessFile file = this.dataManager.getDataFile(item).getRandomAccessFile();
        file.seek(item.getOffset());
        byte rc = file.readByte();
        item.setSize(file.readInt());
        return rc;
    }

    public synchronized Object readItem(Marshaller marshaller, StoreLocation item) throws IOException {
        RandomAccessFile file = this.dataManager.getDataFile(item).getRandomAccessFile();
        byte[] data = new byte[item.getSize()];
        file.seek(item.getOffset() + 5L);
        file.readFully(data);
        this.dataIn.restart(data);
        return marshaller.readPayload(this.dataIn);
    }
}

