/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.activemq.filter.DestinationMapEntry;

public class AuthorizationEntry
extends DestinationMapEntry {
    private Set<Object> readACLs = this.emptySet();
    private Set<Object> writeACLs = this.emptySet();
    private Set<Object> adminACLs = this.emptySet();
    private String adminRoles;
    private String readRoles;
    private String writeRoles;
    private String groupClass = "org.apache.activemq.jaas.GroupPrincipal";

    public String getGroupClass() {
        return this.groupClass;
    }

    private Set<Object> emptySet() {
        return Collections.EMPTY_SET;
    }

    public void setGroupClass(String groupClass) {
        this.groupClass = groupClass;
    }

    public Set<Object> getAdminACLs() {
        return this.adminACLs;
    }

    public void setAdminACLs(Set<Object> adminACLs) {
        this.adminACLs = adminACLs;
    }

    public Set<Object> getReadACLs() {
        return this.readACLs;
    }

    public void setReadACLs(Set<Object> readACLs) {
        this.readACLs = readACLs;
    }

    public Set<Object> getWriteACLs() {
        return this.writeACLs;
    }

    public void setWriteACLs(Set<Object> writeACLs) {
        this.writeACLs = writeACLs;
    }

    public void setAdmin(String roles) throws Exception {
        this.adminRoles = roles;
        this.setAdminACLs(this.parseACLs(this.adminRoles));
    }

    public void setRead(String roles) throws Exception {
        this.readRoles = roles;
        this.setReadACLs(this.parseACLs(this.readRoles));
    }

    public void setWrite(String roles) throws Exception {
        this.writeRoles = roles;
        this.setWriteACLs(this.parseACLs(this.writeRoles));
    }

    protected Set<Object> parseACLs(String roles) throws Exception {
        HashSet<Object> answer = new HashSet<Object>();
        StringTokenizer iter = new StringTokenizer(roles, ",");
        while (iter.hasMoreTokens()) {
            Class<?>[] paramTypes;
            Object instance;
            Class<?>[] paramTypes2;
            int i;
            String name = iter.nextToken().trim();
            Object[] param = new Object[]{name};
            Class<?> cls = Class.forName(this.groupClass);
            Constructor<?>[] constructors = cls.getConstructors();
            for (i = 0; !(i >= constructors.length || (paramTypes2 = constructors[i].getParameterTypes()).length != 0 && paramTypes2[0].equals(String.class)); ++i) {
            }
            if (i < constructors.length) {
                instance = constructors[i].newInstance(param);
                answer.add(instance);
                continue;
            }
            instance = cls.newInstance();
            Method[] methods = cls.getMethods();
            i = 0;
            for (i = 0; !(i >= methods.length || (paramTypes = methods[i].getParameterTypes()).length != 0 && methods[i].getName().equals("setName") && paramTypes[0].equals(String.class)); ++i) {
            }
            if (i < methods.length) {
                methods[i].invoke(instance, param);
                answer.add(instance);
                continue;
            }
            throw new NoSuchMethodException();
        }
        return answer;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.adminRoles != null) {
            this.setAdminACLs(this.parseACLs(this.adminRoles));
        }
        if (this.writeRoles != null) {
            this.setWriteACLs(this.parseACLs(this.writeRoles));
        }
        if (this.readRoles != null) {
            this.setReadACLs(this.parseACLs(this.readRoles));
        }
    }
}

