/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.iq80.leveldb.impl.Compaction;
import org.iq80.leveldb.impl.FileMetaData;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.impl.InternalKeyComparator;
import org.iq80.leveldb.impl.Level;
import org.iq80.leveldb.impl.Level0;
import org.iq80.leveldb.impl.LookupKey;
import org.iq80.leveldb.impl.LookupResult;
import org.iq80.leveldb.impl.ReadStats;
import org.iq80.leveldb.impl.SeekingIterable;
import org.iq80.leveldb.impl.TableCache;
import org.iq80.leveldb.impl.ValueType;
import org.iq80.leveldb.impl.VersionSet;
import org.iq80.leveldb.util.InternalIterator;
import org.iq80.leveldb.util.InternalTableIterator;
import org.iq80.leveldb.util.LevelIterator;
import org.iq80.leveldb.util.MergingIterator;
import org.iq80.leveldb.util.Slice;

public class Version
implements SeekingIterable<InternalKey, Slice> {
    private final AtomicInteger retained = new AtomicInteger(1);
    private final VersionSet versionSet;
    private final Level0 level0;
    private final List<Level> levels;
    private int compactionLevel;
    private double compactionScore;
    private FileMetaData fileToCompact;
    private int fileToCompactLevel;

    public Version(VersionSet versionSet) {
        this.versionSet = versionSet;
        Preconditions.checkArgument((boolean)true, (Object)"levels must be at least 2");
        this.level0 = new Level0(Lists.newArrayList(), this.getTableCache(), this.getInternalKeyComparator());
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 1; i < 7; ++i) {
            ArrayList files = Lists.newArrayList();
            builder.add((Object)new Level(i, files, this.getTableCache(), this.getInternalKeyComparator()));
        }
        this.levels = builder.build();
    }

    private TableCache getTableCache() {
        return this.versionSet.getTableCache();
    }

    public InternalKeyComparator getInternalKeyComparator() {
        return this.versionSet.getInternalKeyComparator();
    }

    public synchronized int getCompactionLevel() {
        return this.compactionLevel;
    }

    public synchronized void setCompactionLevel(int compactionLevel) {
        this.compactionLevel = compactionLevel;
    }

    public synchronized double getCompactionScore() {
        return this.compactionScore;
    }

    public synchronized void setCompactionScore(double compactionScore) {
        this.compactionScore = compactionScore;
    }

    public MergingIterator iterator() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)this.level0.iterator());
        builder.addAll(this.getLevelIterators());
        return new MergingIterator((List<? extends InternalIterator>)builder.build(), this.getInternalKeyComparator());
    }

    List<InternalTableIterator> getLevel0Files() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (FileMetaData file : this.level0.getFiles()) {
            builder.add((Object)this.getTableCache().newIterator(file));
        }
        return builder.build();
    }

    List<LevelIterator> getLevelIterators() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Level level : this.levels) {
            if (level.getFiles().size() <= 0) continue;
            builder.add((Object)level.iterator());
        }
        return builder.build();
    }

    public LookupResult get(LookupKey key) {
        ReadStats readStats = new ReadStats();
        LookupResult lookupResult = this.level0.get(key, readStats);
        if (lookupResult == null) {
            Level level;
            Iterator<Level> i$ = this.levels.iterator();
            while (i$.hasNext() && (lookupResult = (level = i$.next()).get(key, readStats)) == null) {
            }
        }
        this.updateStats(readStats.getSeekFileLevel(), readStats.getSeekFile());
        return lookupResult;
    }

    int pickLevelForMemTableOutput(Slice smallestUserKey, Slice largestUserKey) {
        int level;
        if (!this.overlapInLevel(0, smallestUserKey, largestUserKey)) {
            long sum;
            InternalKey start = new InternalKey(smallestUserKey, 0xFFFFFFFFFFFFFFL, ValueType.VALUE);
            InternalKey limit = new InternalKey(largestUserKey, 0L, ValueType.VALUE);
            for (level = 0; level < 2 && !this.overlapInLevel(level + 1, smallestUserKey, largestUserKey) && (sum = Compaction.totalFileSize(this.versionSet.getOverlappingInputs(level + 2, start, limit))) <= 0x1400000L; ++level) {
            }
        }
        return level;
    }

    public boolean overlapInLevel(int level, Slice smallestUserKey, Slice largestUserKey) {
        Preconditions.checkPositionIndex((int)level, (int)this.levels.size(), (String)"Invalid level");
        Preconditions.checkNotNull((Object)smallestUserKey, (Object)"smallestUserKey is null");
        Preconditions.checkNotNull((Object)largestUserKey, (Object)"largestUserKey is null");
        if (level == 0) {
            return this.level0.someFileOverlapsRange(smallestUserKey, largestUserKey);
        }
        return this.levels.get(level - 1).someFileOverlapsRange(smallestUserKey, largestUserKey);
    }

    public int numberOfLevels() {
        return this.levels.size() + 1;
    }

    public int numberOfFilesInLevel(int level) {
        if (level == 0) {
            return this.level0.getFiles().size();
        }
        return this.levels.get(level - 1).getFiles().size();
    }

    public Multimap<Integer, FileMetaData> getFiles() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder = builder.orderKeysBy((Comparator)Ordering.natural());
        builder.putAll((Object)0, this.level0.getFiles());
        for (Level level : this.levels) {
            builder.putAll((Object)level.getLevelNumber(), level.getFiles());
        }
        return builder.build();
    }

    public List<FileMetaData> getFiles(int level) {
        if (level == 0) {
            return this.level0.getFiles();
        }
        return this.levels.get(level - 1).getFiles();
    }

    public void addFile(int level, FileMetaData fileMetaData) {
        if (level == 0) {
            this.level0.addFile(fileMetaData);
        } else {
            this.levels.get(level - 1).addFile(fileMetaData);
        }
    }

    private boolean updateStats(int seekFileLevel, FileMetaData seekFile) {
        if (seekFile == null) {
            return false;
        }
        seekFile.decrementAllowedSeeks();
        if (seekFile.getAllowedSeeks() <= 0 && this.fileToCompact == null) {
            this.fileToCompact = seekFile;
            this.fileToCompactLevel = seekFileLevel;
            return true;
        }
        return false;
    }

    public FileMetaData getFileToCompact() {
        return this.fileToCompact;
    }

    public int getFileToCompactLevel() {
        return this.fileToCompactLevel;
    }

    public long getApproximateOffsetOf(InternalKey key) {
        long result = 0L;
        block0: for (int level = 0; level < 7; ++level) {
            for (FileMetaData fileMetaData : this.getFiles(level)) {
                if (this.getInternalKeyComparator().compare(fileMetaData.getLargest(), key) <= 0) {
                    result += fileMetaData.getFileSize();
                    continue;
                }
                if (this.getInternalKeyComparator().compare(fileMetaData.getSmallest(), key) > 0) {
                    if (level <= 0) continue;
                    continue block0;
                }
                result += this.getTableCache().getApproximateOffsetOf(fileMetaData, key.encode());
            }
        }
        return result;
    }

    public void retain() {
        int was = this.retained.getAndIncrement();
        assert (was > 0) : "Version was retain after it was disposed.";
    }

    public void release() {
        int now = this.retained.decrementAndGet();
        assert (now >= 0) : "Version was released after it was disposed.";
        if (now == 0) {
            this.versionSet.removeVersion(this);
        }
    }

    public boolean isDisposed() {
        return this.retained.get() <= 0;
    }
}

