/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.buffer;

import gr.uoa.di.madgik.grs.buffer.GRS2BufferDisposedException;
import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.buffer.GRS2BufferInitializationException;
import gr.uoa.di.madgik.grs.buffer.GRS2BufferInvalidArgumentException;
import gr.uoa.di.madgik.grs.buffer.GRS2BufferInvalidOperationException;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.proxy.mirror.IMirror;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.registry.GRSRegistry;
import gr.uoa.di.madgik.grs.store.buffer.IBufferStore;
import java.util.LinkedList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class QueueBuffer
implements IBuffer {
    private static Logger logger = Logger.getLogger(QueueBuffer.class.getName());
    public static int DefaultCapacity = 50;
    public static int DefaultConcurrentPartial = 1;
    public static float DefaultThreshold = 0.5f;
    public static long DefaultInactivityTimeout = 100L;
    public static TimeUnit DefaultInactivityTimeUnit = TimeUnit.SECONDS;
    public static float DefaultMirrorBufferFactor = 0.5f;
    private ArrayBlockingQueue<Record> queueForward = null;
    private ArrayBlockingQueue<Record> queueBackward = null;
    private int capacity = DefaultCapacity;
    private int concurrentPartial = DefaultConcurrentPartial;
    private int mirrorBuffer = (int)Math.ceil((float)DefaultCapacity * DefaultMirrorBufferFactor);
    private float notificationThreshold = DefaultThreshold;
    private IBuffer.TransportDirective directive = IBuffer.TransportDirective.Full;
    private long inactivityTimeout = DefaultInactivityTimeout;
    private TimeUnit inactivityTimeUnit = DefaultInactivityTimeUnit;
    private IMirror mirror = null;
    private long totalRecords = 0L;
    private IBuffer.Status status = IBuffer.Status.Init;
    private String key = null;
    private final Object writerThresholdNotificationObject = new Object();
    private final Object readerThresholdNotificationObject = new Object();
    private final Object writerImmediateNotificationObject = new Object();
    private final Object readerImmediateNotificationObject = new Object();
    private RecordDefinition[] definitions = null;
    private long lastActivityTime = System.currentTimeMillis();
    private boolean simulateActivity = false;
    private LinkedList<BufferEvent> eventsFromReader = null;
    private LinkedList<BufferEvent> eventsFromWriter = null;
    private IBufferStore store = null;

    @Override
    public void setMirror(IMirror mirror) {
        this.mirror = mirror;
    }

    @Override
    public IMirror getMirror() {
        return this.mirror;
    }

    @Override
    public long getLastActivityTime() {
        return this.lastActivityTime;
    }

    @Override
    public synchronized void markSimulateActivity() {
        this.lastActivityTime = System.currentTimeMillis();
        this.simulateActivity = true;
    }

    @Override
    public synchronized boolean getSimulateActivity() {
        boolean status = this.simulateActivity;
        this.simulateActivity = false;
        return status;
    }

    @Override
    public RecordDefinition[] getRecordDefinitions() throws GRS2BufferDisposedException {
        if (this.status == IBuffer.Status.Dispose) {
            throw new GRS2BufferDisposedException("Buffer is disposed");
        }
        return this.definitions;
    }

    @Override
    public void setRecordDefinitions(RecordDefinition[] definitions) throws GRS2BufferInitializationException {
        if (this.status != IBuffer.Status.Init) {
            throw new GRS2BufferInitializationException("Record definitions can only be set before buffer initialization");
        }
        this.definitions = definitions;
    }

    @Override
    public IBuffer.TransportDirective getTransportDirective() throws GRS2BufferDisposedException {
        if (this.status == IBuffer.Status.Dispose) {
            throw new GRS2BufferDisposedException("Buffer is disposed");
        }
        return this.directive;
    }

    @Override
    public void setTransportDirective(IBuffer.TransportDirective directive) throws GRS2BufferInitializationException, GRS2BufferInvalidArgumentException {
        if (this.status != IBuffer.Status.Init) {
            throw new GRS2BufferInitializationException("Transport directive can only be set before buffer initialization");
        }
        if (directive == IBuffer.TransportDirective.Inherit) {
            throw new GRS2BufferInvalidArgumentException("Transport directive of buffer cannot have the value of " + directive.toString());
        }
        this.directive = directive;
    }

    @Override
    public IBuffer.TransportDirective resolveTransportDirective() throws GRS2BufferDisposedException {
        switch (this.getTransportDirective()) {
            case Full: 
            case Partial: {
                return this.getTransportDirective();
            }
        }
        return IBuffer.TransportDirective.Full;
    }

    @Override
    public synchronized int getCapacity() throws GRS2BufferDisposedException {
        if (this.status == IBuffer.Status.Dispose) {
            throw new GRS2BufferDisposedException("Buffer is disposed");
        }
        return this.capacity;
    }

    @Override
    public synchronized void setCapacity(int capacity) throws GRS2BufferDisposedException, GRS2BufferInitializationException, GRS2BufferInvalidArgumentException {
        if (this.status == IBuffer.Status.Dispose) {
            throw new GRS2BufferDisposedException("Buffer is disposed");
        }
        if (this.status != IBuffer.Status.Init) {
            throw new GRS2BufferInitializationException("Capacity can only be set before buffer initialization");
        }
        if (capacity <= 0) {
            throw new GRS2BufferInvalidArgumentException("Capacity must be greater than 0");
        }
        this.capacity = capacity;
    }

    @Override
    public int getConcurrentPartialCapacity() throws GRS2BufferException {
        if (this.status == IBuffer.Status.Dispose) {
            throw new GRS2BufferDisposedException("Buffer is disposed");
        }
        return this.concurrentPartial;
    }

    @Override
    public void setConcurrentPartialCapacity(int capacity) throws GRS2BufferDisposedException, GRS2BufferInitializationException, GRS2BufferInvalidArgumentException {
        if (this.status == IBuffer.Status.Dispose) {
            throw new GRS2BufferDisposedException("Buffer is disposed");
        }
        if (this.status != IBuffer.Status.Init) {
            throw new GRS2BufferInitializationException("Capacity can only be set before buffer initialization");
        }
        if (capacity <= 0) {
            throw new GRS2BufferInvalidArgumentException("Capacity must be greater than 0");
        }
        this.concurrentPartial = capacity;
    }

    @Override
    public void setMirrorBuffer(int size) throws GRS2BufferDisposedException, GRS2BufferInitializationException {
        if (this.status == IBuffer.Status.Dispose) {
            throw new GRS2BufferDisposedException("Buffer is disposed");
        }
        if (this.status != IBuffer.Status.Init) {
            throw new GRS2BufferInitializationException("Mirror buffer can only be set before buffer initialization");
        }
        this.mirrorBuffer = size;
    }

    @Override
    public int getMirrorBuffer() throws GRS2BufferDisposedException {
        if (this.status == IBuffer.Status.Dispose) {
            throw new GRS2BufferDisposedException("Buffer is disposed");
        }
        return this.mirrorBuffer;
    }

    @Override
    public TimeUnit getInactivityTimeUnit() throws GRS2BufferDisposedException {
        if (this.status == IBuffer.Status.Dispose) {
            throw new GRS2BufferDisposedException("Buffer is disposed");
        }
        return this.inactivityTimeUnit;
    }

    @Override
    public void setInactivityTimeUnit(TimeUnit unit) throws GRS2BufferDisposedException {
        if (this.status == IBuffer.Status.Dispose) {
            throw new GRS2BufferDisposedException("Buffer is disposed");
        }
        this.inactivityTimeUnit = unit;
    }

    @Override
    public long getInactivityTimeout() throws GRS2BufferDisposedException {
        if (this.status == IBuffer.Status.Dispose) {
            throw new GRS2BufferDisposedException("Buffer is disposed");
        }
        return this.inactivityTimeout;
    }

    @Override
    public void setInactivityTimeout(long timeout) throws GRS2BufferDisposedException {
        if (this.status == IBuffer.Status.Dispose) {
            throw new GRS2BufferDisposedException("Buffer is disposed");
        }
        this.inactivityTimeout = timeout;
    }

    @Override
    public Object getWriterImmediateNotificationObject() throws GRS2BufferDisposedException {
        if (this.status == IBuffer.Status.Dispose) {
            throw new GRS2BufferDisposedException("Buffer is disposed");
        }
        return this.writerImmediateNotificationObject;
    }

    @Override
    public Object getReaderImmediateNotificationObject() throws GRS2BufferDisposedException {
        if (this.status == IBuffer.Status.Dispose) {
            throw new GRS2BufferDisposedException("Buffer is disposed");
        }
        return this.readerImmediateNotificationObject;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) throws GRS2BufferInvalidArgumentException, GRS2BufferInvalidOperationException {
        if (key == null || key.trim().length() == 0) {
            throw new GRS2BufferInvalidArgumentException("Key cannot be null or emtpy");
        }
        if (this.key != null) {
            throw new GRS2BufferInvalidOperationException("Buffer is already assigned with a key");
        }
        this.key = key;
    }

    @Override
    public synchronized void initialize() throws GRS2BufferDisposedException, GRS2BufferInitializationException, GRS2BufferInvalidArgumentException {
        if (this.status == IBuffer.Status.Dispose) {
            throw new GRS2BufferDisposedException("Buffer is disposed");
        }
        if (this.status != IBuffer.Status.Init) {
            throw new GRS2BufferInitializationException("Initialization can only be performed once");
        }
        if (this.capacity <= 0) {
            throw new GRS2BufferInvalidArgumentException("Capacity must be greater than 0");
        }
        if (this.concurrentPartial <= 0) {
            throw new GRS2BufferInvalidArgumentException("Concurrent partial capacity must be greater than 0");
        }
        if (this.notificationThreshold < 0.0f || this.notificationThreshold > 1.0f) {
            throw new GRS2BufferInvalidArgumentException("Threshold must be between 0 and 1");
        }
        this.queueForward = new ArrayBlockingQueue(this.capacity);
        this.queueBackward = new ArrayBlockingQueue(this.capacity + this.concurrentPartial);
        this.eventsFromReader = new LinkedList();
        this.eventsFromWriter = new LinkedList();
        this.status = IBuffer.Status.Open;
        this.lastActivityTime = System.currentTimeMillis();
        if (this.store != null) {
            this.store.markActivity();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Initialized QueueBuffer with capacity (" + this.capacity + "), threshold (" + this.notificationThreshold + ")");
        }
    }

    @Override
    public synchronized IBuffer.Status getStatus() {
        return this.status;
    }

    @Override
    public synchronized int availableRecords() throws GRS2BufferDisposedException, GRS2BufferInitializationException {
        if (this.status == IBuffer.Status.Dispose) {
            throw new GRS2BufferDisposedException("Buffer is disposed");
        }
        if (this.status == IBuffer.Status.Init) {
            throw new GRS2BufferInitializationException("Buffer not yet initialized");
        }
        return this.queueForward.size();
    }

    @Override
    public synchronized long totalRecords() throws GRS2BufferDisposedException, GRS2BufferInitializationException {
        if (this.status == IBuffer.Status.Dispose) {
            throw new GRS2BufferDisposedException("Buffer is disposed");
        }
        if (this.status == IBuffer.Status.Init) {
            throw new GRS2BufferInitializationException("Buffer not yet initialized");
        }
        return this.totalRecords;
    }

    @Override
    public void setBufferStore(IBufferStore store) throws GRS2BufferException {
        if (this.status == IBuffer.Status.Dispose) {
            throw new GRS2BufferDisposedException("Buffer is disposed");
        }
        if (this.status == IBuffer.Status.Init) {
            throw new GRS2BufferInitializationException("Buffer not yet initialized");
        }
        this.store = store;
    }

    @Override
    public synchronized boolean put(Record record) throws GRS2BufferException, GRS2RecordDefinitionException {
        if (this.status == IBuffer.Status.Dispose) {
            throw new GRS2BufferDisposedException("Buffer is disposed");
        }
        if (this.status != IBuffer.Status.Open) {
            throw new GRS2BufferInitializationException("Records can be added only when buffer is in open state");
        }
        boolean success = this.queueForward.offer(record);
        if (success) {
            ++this.totalRecords;
            record.bind(this);
            this.notifyImmediateReaders();
            if (this.status == IBuffer.Status.Open && this.queueForward.size() >= 1) {
                this.notifyThresholdReaders();
            }
        }
        this.lastActivityTime = System.currentTimeMillis();
        if (this.store != null) {
            this.store.markActivity();
        }
        return success;
    }

    @Override
    public synchronized Record get() throws GRS2BufferDisposedException, GRS2BufferInitializationException {
        if (this.status == IBuffer.Status.Dispose) {
            throw new GRS2BufferDisposedException("Buffer is disposed");
        }
        if (this.status == IBuffer.Status.Init) {
            throw new GRS2BufferInitializationException("Buffer not yet initialized");
        }
        Record rec = this.queueForward.poll();
        if (rec != null) {
            Record recBack;
            if (this.queueBackward.remainingCapacity() == 0 && (recBack = this.queueBackward.poll()) != null && recBack.isBoundTo(this)) {
                recBack.dispose();
            }
            this.queueBackward.add(rec);
            this.notifyImmediateWriters();
            if (this.status == IBuffer.Status.Open && (double)this.queueForward.remainingCapacity() >= Math.ceil((float)this.capacity * (1.0f - this.notificationThreshold))) {
                this.notifyThresholdWriters();
            }
        }
        this.lastActivityTime = System.currentTimeMillis();
        if (this.store != null) {
            this.store.markActivity();
        }
        return rec;
    }

    @Override
    public synchronized Record locate(long recordIndex) throws GRS2BufferDisposedException, GRS2BufferInitializationException {
        if (this.status == IBuffer.Status.Dispose) {
            throw new GRS2BufferDisposedException("Buffer is disposed");
        }
        if (this.status == IBuffer.Status.Init) {
            throw new GRS2BufferInitializationException("Buffer not yet initialized");
        }
        if (this.queueBackward != null) {
            for (Record item : this.queueBackward) {
                if (item.getID() != recordIndex) continue;
                return item;
            }
        }
        if (this.queueForward != null) {
            for (Record item : this.queueForward) {
                if (item.getID() != recordIndex) continue;
                return item;
            }
        }
        return null;
    }

    @Override
    public synchronized void close() throws GRS2BufferDisposedException, GRS2BufferInitializationException {
        if (this.status == IBuffer.Status.Dispose) {
            throw new GRS2BufferDisposedException("Buffer is disposed");
        }
        if (this.status == IBuffer.Status.Init) {
            throw new GRS2BufferInitializationException("Buffer not yet initialized");
        }
        this.status = IBuffer.Status.Close;
        this.notifyImmediateWriters();
        this.notifyThresholdWriters();
        this.notifyImmediateReaders();
        this.notifyThresholdReaders();
        this.lastActivityTime = System.currentTimeMillis();
        if (this.store != null) {
            this.store.markActivity();
        }
    }

    @Override
    public synchronized void dispose() {
        if (this.status == IBuffer.Status.Dispose) {
            return;
        }
        this.capacity = 0;
        this.totalRecords = 0L;
        if (this.queueForward != null) {
            for (Record rec : this.queueForward) {
                if (!rec.isBoundTo(this)) continue;
                rec.dispose();
            }
            this.queueForward.clear();
        }
        this.queueForward = null;
        if (this.queueBackward != null) {
            for (Record rec : this.queueBackward) {
                if (!rec.isBoundTo(this)) continue;
                rec.dispose();
            }
            this.queueBackward.clear();
        }
        this.queueBackward = null;
        this.status = IBuffer.Status.Dispose;
        if (this.mirror != null) {
            this.mirror.dispose();
        }
        GRSRegistry.Registry.remove(this.key);
        this.notifyImmediateWriters();
        this.notifyThresholdWriters();
        this.notifyImmediateReaders();
        this.notifyThresholdReaders();
    }

    @Override
    public synchronized void emit(BufferEvent event) throws GRS2BufferInvalidArgumentException {
        if (event == null) {
            throw new GRS2BufferInvalidArgumentException("event cannot be null");
        }
        switch (event.getSource()) {
            case Reader: {
                this.eventsFromReader.offer(event);
                break;
            }
            case Writer: {
                this.eventsFromWriter.offer(event);
                break;
            }
            default: {
                throw new GRS2BufferInvalidArgumentException("Unrecogized source of event");
            }
        }
    }

    @Override
    public synchronized BufferEvent receive(BufferEvent.EventSource source) throws GRS2BufferInvalidArgumentException {
        switch (source) {
            case Reader: {
                return this.eventsFromReader.poll();
            }
            case Writer: {
                return this.eventsFromWriter.poll();
            }
        }
        throw new GRS2BufferInvalidArgumentException("Unrecogized source of event");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyThresholdWriters() {
        Object object = this.writerThresholdNotificationObject;
        synchronized (object) {
            this.writerThresholdNotificationObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyThresholdReaders() {
        Object object = this.readerThresholdNotificationObject;
        synchronized (object) {
            this.readerThresholdNotificationObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyImmediateWriters() {
        Object object = this.writerImmediateNotificationObject;
        synchronized (object) {
            this.writerImmediateNotificationObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyImmediateReaders() {
        Object object = this.readerImmediateNotificationObject;
        synchronized (object) {
            this.readerImmediateNotificationObject.notifyAll();
        }
    }
}

