/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds.aggregator.impl;

import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.apache.axis.MessageContext;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.mds.aggregator.impl.AggregatorConfiguration;
import org.globus.mds.aggregator.impl.AggregatorException;
import org.globus.mds.aggregator.impl.AggregatorParamTypeNotSupportedException;
import org.globus.mds.aggregator.impl.AggregatorServiceGroupEntryResource;
import org.globus.mds.aggregator.impl.AggregatorSink;
import org.globus.mds.aggregator.impl.AggregatorSinkTypeNotSupportedException;
import org.globus.mds.aggregator.impl.AggregatorSource;
import org.globus.mds.aggregator.impl.AggregatorUtils;
import org.globus.mds.aggregator.types.AggregatorConfig;
import org.globus.mds.aggregator.types.AggregatorContent;
import org.globus.mds.usefulrp.AccumulatorResourceProperty;
import org.globus.mds.usefulrp.ServiceMetaDataResourceProperty;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.ResourceProperties;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertySet;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.globus.wsrf.impl.SimpleResourcePropertySet;
import org.globus.wsrf.impl.servicegroup.EntryResourceProperty;
import org.globus.wsrf.impl.servicegroup.EntryResourcePropertyTopic;
import org.globus.wsrf.impl.servicegroup.ServiceGroupConstants;
import org.globus.wsrf.impl.servicegroup.ServiceGroupRegistrationResource;
import org.globus.wsrf.impl.servicegroup.ServiceGroupResource;
import org.globus.wsrf.utils.AddressingUtils;
import org.globus.wsrf.utils.FaultHelper;
import org.globus.wsrf.utils.XmlUtils;
import org.oasis.wsrf.faults.BaseFaultType;
import org.oasis.wsrf.servicegroup.Add;
import org.oasis.wsrf.servicegroup.AddRefusedFaultType;
import org.oasis.wsrf.servicegroup.ContentCreationFailedFaultType;
import org.oasis.wsrf.servicegroup.UnsupportedMemberInterfaceFaultType;
import org.w3c.dom.Element;

public class AggregatorServiceGroupResource
implements ResourceProperties,
ServiceGroupRegistrationResource {
    public static final long DEFAULT_SWEEP_PERIOD = 300000L;
    private static Log logger = LogFactory.getLog((String)(class$org$globus$mds$aggregator$impl$AggregatorServiceGroupResource == null ? (class$org$globus$mds$aggregator$impl$AggregatorServiceGroupResource = AggregatorServiceGroupResource.class$("org.globus.mds.aggregator.impl.AggregatorServiceGroupResource")) : class$org$globus$mds$aggregator$impl$AggregatorServiceGroupResource).getName());
    public static final QName RP_SET = new QName("http://mds.globus.org/aggregator", "AggregatorServiceGroupRP");
    public static final QName REGISTRATION_COUNT_RP = new QName("http://mds.globus.org/aggregator", "RegistrationCount");
    ResourcePropertySet propSet;
    Hashtable entries = new Hashtable();
    Hashtable sessionKeys = new Hashtable();
    Hashtable entryCache = null;
    boolean entryCacheDirty = false;
    EntrySweeper entrySweeper = new EntrySweeper();
    private long sweeperInterval = 300000L;
    ArrayList sources = new ArrayList();
    AccumulatorResourceProperty registrationCountRP;
    ServiceMetaDataResourceProperty metadata;
    AggregatorConfiguration configuration = null;
    private ResourceKey key = new SimpleResourceKey(ServiceGroupConstants.KEY, (Object)String.valueOf(this.hashCode()));
    static /* synthetic */ Class class$org$globus$mds$aggregator$impl$AggregatorServiceGroupResource;
    static /* synthetic */ Class class$org$globus$mds$aggregator$impl$AggregatorSink;
    static /* synthetic */ Class class$org$globus$mds$aggregator$types$AggregatorContent;

    protected void init(QName rpSetName) {
        this.propSet = new SimpleResourcePropertySet(rpSetName);
        try {
            EntryResourceProperty prop = new EntryResourceProperty((ServiceGroupResource)this);
            this.propSet.add((ResourceProperty)prop);
        }
        catch (Exception e) {
            logger.error((Object)"Couldn't set up Entry RP");
        }
        try {
            this.registrationCountRP = new AccumulatorResourceProperty(REGISTRATION_COUNT_RP);
            this.propSet.add((ResourceProperty)this.registrationCountRP);
        }
        catch (Exception e) {
            logger.error((Object)"Couldn't set up registration count RP");
        }
        try {
            this.metadata = new ServiceMetaDataResourceProperty();
            this.propSet.add((ResourceProperty)this.metadata);
        }
        catch (Exception e) {
            logger.error((Object)"Couldn't set up metadata RP");
        }
        this.sweeperInterval = this.getConfiguration().getEntrySweeperInterval();
        this.entrySweeper.setDaemon(true);
        this.entrySweeper.start();
    }

    public void addAggregatorSource(AggregatorSource source) {
        this.sources.add(source);
    }

    public ResourcePropertySet getResourcePropertySet() {
        return this.propSet;
    }

    public void setVersion(String version) {
        this.metadata.setVersion(version);
    }

    public ResourceKey getKey() {
        return this.key;
    }

    public synchronized Iterator iterateEntryKeys() {
        if (this.entryCache == null || this.isEntryCacheDirty()) {
            this.entryCache = (Hashtable)this.entries.clone();
            this.setEntryCacheDirty(false);
        }
        return this.entryCache.keySet().iterator();
    }

    public synchronized Iterator iterateEntryValues() {
        if (this.entryCache == null || this.isEntryCacheDirty()) {
            this.entryCache = (Hashtable)this.entries.clone();
            this.setEntryCacheDirty(false);
        }
        return this.entryCache.entrySet().iterator();
    }

    private boolean isEntryCacheDirty() {
        return this.entryCacheDirty;
    }

    private synchronized void setEntryCacheDirty(boolean dirty) {
        this.entryCacheDirty = dirty;
    }

    public AggregatorConfiguration getConfiguration() {
        if (this.configuration != null) {
            return this.configuration;
        }
        MessageContext ctx = MessageContext.getCurrentContext();
        String servicePath = ctx.getTargetService();
        String jndiName = "java:comp/env//services/" + servicePath + "/configuration";
        logger.debug((Object)("Will read configuration from jndi name: " + jndiName));
        try {
            InitialContext initialContext = new InitialContext();
            this.configuration = (AggregatorConfiguration)initialContext.lookup(jndiName);
        }
        catch (NamingException e) {
            logger.error((Object)("when performing JNDI lookup for " + jndiName + ": " + e));
        }
        catch (Exception e) {
            logger.error((Object)("when performing JNDI lookup for " + jndiName + ": " + e));
        }
        return this.configuration;
    }

    public void loadCompatibleSources(AggregatorSink sink) throws Exception {
        String aggregatorClassName = "";
        ArrayList sources = this.getConfiguration().getAggregatorSourceList();
        for (int i = 0; i < sources.size(); ++i) {
            try {
                aggregatorClassName = (String)sources.get(i);
                Constructor<?> sourceConstructor = Class.forName(aggregatorClassName).getConstructor(class$org$globus$mds$aggregator$impl$AggregatorSink == null ? AggregatorServiceGroupResource.class$("org.globus.mds.aggregator.impl.AggregatorSink") : class$org$globus$mds$aggregator$impl$AggregatorSink);
                AggregatorSource src = (AggregatorSource)sourceConstructor.newInstance(sink);
                src.initialize(this.configuration);
                this.addAggregatorSource(src);
                continue;
            }
            catch (Exception e) {
                if (e instanceof AggregatorSinkTypeNotSupportedException) {
                    logger.error((Object)("The Aggregator source " + aggregatorClassName + " is not compatible with the specified Aggregator sink " + sink.getClass().getName()));
                } else {
                    logger.error((Object)("Unknown exception during Aggregator initialization: " + e));
                }
                throw e;
            }
        }
    }

    public EndpointReferenceType serviceGroupAdd(Add add) throws RemoteException, AddRefusedFaultType, ContentCreationFailedFaultType, UnsupportedMemberInterfaceFaultType {
        this.registrationCountRP.accumulate(1L);
        AggregatorContent content = null;
        Object obj = add.getContent();
        if (obj instanceof SOAPElement) {
            try {
                content = (AggregatorContent)ObjectDeserializer.toObject((SOAPElement)((SOAPElement)obj), (Class)(class$org$globus$mds$aggregator$types$AggregatorContent == null ? (class$org$globus$mds$aggregator$types$AggregatorContent = AggregatorServiceGroupResource.class$("org.globus.mds.aggregator.types.AggregatorContent")) : class$org$globus$mds$aggregator$types$AggregatorContent));
            }
            catch (Exception e) {
                logger.warn((Object)("Exception deserializing Content parameter: " + e.toString()));
            }
        } else if (obj instanceof AggregatorContent) {
            content = (AggregatorContent)obj;
        }
        EndpointReferenceType entryEPR = null;
        EndpointReferenceType serviceGroupEPR = null;
        try {
            serviceGroupEPR = AddressingUtils.createEndpointReference(null);
        }
        catch (Exception e1) {
            throw new RemoteException("", e1);
        }
        if (AggregatorUtils.detectLoopback(add.getMemberEPR(), serviceGroupEPR)) {
            AddRefusedFaultType fault = new AddRefusedFaultType();
            FaultHelper faultHelper = new FaultHelper((BaseFaultType)fault);
            faultHelper.setDescription("Loopback or duplicate registrant address submitted");
            throw fault;
        }
        AggregatorServiceGroupEntryResource entry = new AggregatorServiceGroupEntryResource(this, add.getMemberEPR(), serviceGroupEPR, content);
        ResourceKey key = entry.getKey();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created new resource key: " + key));
        }
        MessageContext msgContext = MessageContext.getCurrentContext();
        String transportURL = (String)msgContext.getProperty("transport.url");
        transportURL = transportURL + "Entry";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Will use transport URL in entry EPRs: " + transportURL));
        }
        try {
            entryEPR = AddressingUtils.createEndpointReference((String)transportURL, (ResourceKey)key);
        }
        catch (Exception e1) {
            throw new RemoteException("", e1);
        }
        entry.setEntryEPR(entryEPR);
        entry.setTerminationTime(add.getInitialTerminationTime());
        try {
            AggregatorConfig parameters = content.getAggregatorConfig();
            if (parameters == null) {
                throw new AggregatorException("Parameters argument is null!");
            }
            if (!(parameters instanceof AggregatorConfig)) {
                throw new AggregatorException("Invalid Parameter Type (expected AggregatorConfig, but got " + parameters.getClass() + ")");
            }
            AggregatorSource source = null;
            boolean found = false;
            for (int i = 0; i < this.sources.size(); ++i) {
                try {
                    source = (AggregatorSource)this.sources.get(i);
                    String sessionKey = source.addAggregation(parameters, entry);
                    entry.setAggregatorSource(source);
                    this.sessionKeys.put(key, sessionKey);
                    found = true;
                    break;
                }
                catch (Exception e) {
                    if (e instanceof AggregatorParamTypeNotSupportedException) {
                        if (!logger.isDebugEnabled()) continue;
                        AggregatorConfig config = parameters;
                        logger.debug((Object)("The AggregatorSource " + source.getClass().getName() + " is unable to process the specified parameters: " + XmlUtils.toString((Element)ObjectSerializer.toElement((Object)config, (QName)config.getTypeDesc().getXmlType()))));
                        continue;
                    }
                    throw e;
                }
            }
            if (!found) {
                throw new AggregatorException("addAggregation Operation Failed: Could not locate an Aggregator source that was compatible with the specified parameters");
            }
        }
        catch (Exception e) {
            AddRefusedFaultType fault = new AddRefusedFaultType();
            FaultHelper faultHelper = new FaultHelper((BaseFaultType)fault);
            faultHelper.setDescription("Exception while trying to process a data aggregation instruction");
            faultHelper.addFaultCause((Throwable)e);
            throw fault;
        }
        this.entries.put(key, entry);
        this.setEntryCacheDirty(true);
        this.notifyChange();
        return entryEPR;
    }

    public void notifyChange() {
        try {
            ResourceProperty rpTopic = this.propSet.get(ServiceGroupConstants.ENTRY);
            if (rpTopic instanceof EntryResourcePropertyTopic) {
                ((EntryResourcePropertyTopic)rpTopic).notify(null);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Exception during ResourcePropertyTopic.notify: " + e));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class EntrySweeper
    extends Thread {
        EntrySweeper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Starting EntrySweeper thread...");
            }
            while (true) {
                int totalSwept = 0;
                int totalKept = 0;
                int totalRemoved = 0;
                try {
                    Thread.sleep(AggregatorServiceGroupResource.this.sweeperInterval);
                }
                catch (InterruptedException e) {
                    logger.warn((Object)"EntrySweeper interrupted. Terminating.");
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Starting sweep");
                }
                Hashtable hashtable = AggregatorServiceGroupResource.this.entries;
                synchronized (hashtable) {
                    Iterator i = AggregatorServiceGroupResource.this.entries.entrySet().iterator();
                    DateFormat dateFormat = DateFormat.getTimeInstance(0);
                    while (i.hasNext()) {
                        ++totalSwept;
                        Map.Entry mapEntry = i.next();
                        AggregatorServiceGroupEntryResource entryResource = (AggregatorServiceGroupEntryResource)mapEntry.getValue();
                        ResourceKey entryResourceKey = (ResourceKey)mapEntry.getKey();
                        Calendar now = entryResource.getCurrentTime();
                        Calendar termination = entryResource.getTerminationTime();
                        if (termination == null) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("Entry has infinite lifetime: " + entryResource.toString()));
                            continue;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Checking entry: now=" + dateFormat.format(now.getTime()) + ", termination=" + dateFormat.format(termination.getTime())));
                        }
                        if (now.after(termination)) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"Terminating entry");
                            }
                            String sessionKey = (String)AggregatorServiceGroupResource.this.sessionKeys.get(entryResourceKey);
                            try {
                                AggregatorSource source = entryResource.getAggregatorSource();
                                if (source != null) {
                                    source.removeAggregation(sessionKey);
                                }
                            }
                            catch (Exception e) {
                                logger.warn((Object)("Error while removing aggregation" + e));
                            }
                            try {
                                entryResource.remove();
                            }
                            catch (Exception e) {
                                logger.warn((Object)("Error while invoking resource remove method: " + e));
                            }
                            i.remove();
                            AggregatorServiceGroupResource.this.sessionKeys.remove(entryResourceKey);
                            ++totalRemoved;
                            continue;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Keeping entry");
                        }
                        ++totalKept;
                    }
                }
                if (totalRemoved > 0) {
                    AggregatorServiceGroupResource.this.setEntryCacheDirty(true);
                    AggregatorServiceGroupResource.this.notifyChange();
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Finished sweep, with " + totalKept + " entries kept, " + totalRemoved + " entries removed, out of " + totalSwept + " entries."));
            }
        }
    }
}

