/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import ise.antelope.tasks.util.math.Num;
import ise.antelope.tasks.util.math.Op;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class MathTask
extends Task {
    private String result = null;
    private Op op = null;
    private String operation = null;
    private String operand1 = null;
    private String operand2 = null;
    private String datatype = null;
    private boolean strict = false;

    public void setResult(String name) {
        this.result = name;
    }

    public void setDatatype(String type) {
        if (type.equals("int")) {
            this.datatype = "int";
        } else if (type.equals("long")) {
            this.datatype = "long";
        } else if (type.equals("float")) {
            this.datatype = "float";
        } else if (type.equals("double")) {
            this.datatype = "double";
        } else {
            throw new BuildException("Invalid datatype: " + type + ". Must be one of int, long, float, or double.");
        }
    }

    public void setOperand1(String op) throws BuildException {
        this.operand1 = op;
    }

    public void setOperand2(String op) throws BuildException {
        this.operand2 = op;
    }

    public void setOperation(String op) {
        this.operation = op;
    }

    public void addConfiguredOp(Op op) {
        if (this.op != null) {
            throw new BuildException("Only one operation allowed at a time!");
        }
        if (this.datatype != null) {
            op.setDatatype(this.datatype);
        }
        this.op = op;
    }

    public void setStrict(boolean b) {
        this.strict = b;
    }

    public void execute() {
        Num num;
        if (this.result == null) {
            throw new BuildException("Property name for result is null.");
        }
        if (this.datatype == null) {
            this.datatype = "double";
        }
        if (this.operation != null) {
            this.op = new Op();
            if (this.datatype == null) {
                this.datatype = "double";
            }
            this.op.setDatatype(this.datatype);
            this.op.setOp(this.operation);
            if (this.operand1 != null) {
                num = new Num();
                num.setValue(this.operand1);
                this.op.addConfiguredNum(num);
            }
            if (this.operand2 != null) {
                num = new Num();
                num.setValue(this.operand2);
                this.op.addConfiguredNum(num);
            }
        }
        if (this.op == null) {
            throw new BuildException("Nothing to do!");
        }
        this.op.setDatatype(this.datatype);
        this.op.setStrict(this.strict);
        num = this.op.calculate();
        this.getProject().setUserProperty(this.result, num.getValue().toString());
    }
}

