/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.persistence;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.contexts.service.Consumer;
import org.gcube.common.core.faults.GCUBERetryEquivalentException;
import org.gcube.common.core.persistence.GCUBERIPersistenceManagerProfile;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.GCUBEScheduledHandler;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.core.utils.proxies.AccessControlProxyContext;

public abstract class GCUBERIPersistenceManager {
    protected GCUBELog logger = new GCUBELog(this);
    protected GCUBEServiceContext ctxt;
    protected GCUBERIPersistenceManagerProfile profile;
    protected List<Pattern> excludes = new ArrayList<Pattern>();
    private boolean commit = false;

    public GCUBERIPersistenceManager(GCUBEServiceContext ctxt, GCUBERIPersistenceManagerProfile profile) {
        this.ctxt = ctxt;
        this.profile = profile;
        if (profile.getExcludes() != null) {
            this.exclude(profile.getExcludes().split(","));
        }
        this.logger.setContext(ctxt);
    }

    public void setLogger(GCUBELog logger) {
        this.logger = logger;
    }

    public synchronized void setCommit(boolean value) {
        this.commit = value;
    }

    protected synchronized boolean getCommit() {
        return this.commit;
    }

    protected synchronized void commit() throws Exception {
        if (this.getCommit()) {
            this.logger.trace("committing RI state");
            this.setCommit(false);
            if (GHNContext.getContext().getMode() == GHNContext.Mode.CONNECTED) {
                this.commitState();
            }
        }
    }

    protected abstract void commitState() throws Exception;

    @AccessControlProxyContext.Restricted
    public synchronized void recover() throws Exception {
        this.logger.info("recovering RI state");
        if (GHNContext.getContext().getMode() == GHNContext.Mode.CONNECTED) {
            try {
                this.recoverState();
            }
            catch (StateNotFoundException e) {
                this.logger.warn("remote state could not be retrieved");
            }
            catch (Exception ignore) {
                this.logger.info("no remote state was found");
            }
        }
        if (this.profile.getMonitoringInterval() > 0) {
            new GCUBEScheduledHandler<Object>((long)this.profile.getMonitoringInterval().intValue(), GCUBEScheduledHandler.Mode.LAZY, new GCUBEHandler[]{new GCUBEHandler<Object>(){

                @Override
                public String getName() {
                    return GCUBERIPersistenceManager.this.ctxt.getName() + "RIPersistenceMonitor";
                }

                @Override
                public void run() throws Exception {
                    GCUBERIPersistenceManager.this.commit();
                }
            }}){

                @Override
                protected boolean repeat(Exception exception, int exceptionCount) {
                    if (exception != null) {
                        GCUBERIPersistenceManager.this.logger.warn("could not commit RI state (failures " + exceptionCount + ")", exception);
                    }
                    return true;
                }
            }.run();
        }
        try {
            this.logger.info("subscribing for changes to the state of the RI");
            this.ctxt.subscribeLifetTime(new StateChangeConsumer(), GCUBEServiceContext.RILifetimeTopic.STATECHANGE);
        }
        catch (Exception e) {
            this.logger.error("could not subscribe for RI state changes", e);
            throw e;
        }
    }

    protected abstract void recoverState() throws StateNotFoundException, Exception;

    public void exclude(String ... excludes) {
        for (String ex : excludes) {
            this.excludes.add(Pattern.compile(ex));
        }
    }

    public class StateNotFoundException
    extends GCUBERetryEquivalentException {
        private static final long serialVersionUID = 1L;

        @Override
        public String getMessage() {
            return "state not found";
        }
    }

    protected class StateChangeConsumer
    extends Consumer {
        protected StateChangeConsumer() {
        }

        @Override
        protected void onRIStateChange(GCUBEServiceContext.RILifetimeEvent event) {
            GCUBERIPersistenceManager.this.setCommit(true);
        }
    }
}

