/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.security.impl;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.rpc.Stub;
import org.gcube.common.core.security.SecurityCredentials;
import org.gcube.common.core.security.context.SecurityContextFactory;
import org.gcube.common.core.security.impl.GSSSecurityCredentials;
import org.gcube.common.core.utils.logging.GCUBELog;

public class CredentialManager {
    protected Map<Thread, SecurityCredentials> callCredentials = Collections.synchronizedMap(new WeakHashMap());
    private GCUBELog logger = new GCUBELog(this);

    public SecurityCredentials getContainerCredentials() {
        return new GSSSecurityCredentials(SecurityContextFactory.getInstance().getSecurityContext().getDefaultCredentials());
    }

    public synchronized void setCredentials(Thread thread, SecurityCredentials ... credentials) throws Exception {
        if (credentials.length == 0) {
            credentials = new SecurityCredentials[]{this.getCredentials()};
        }
        SecurityCredentials gssCredentials = credentials[0];
        this.logger.debug("Using credentials of (" + gssCredentials.getCredentialsAsString() + ") in thread " + thread.getName() + "(" + thread.getId() + ")");
        this.callCredentials.put(thread, gssCredentials);
    }

    public SecurityCredentials getCredentials() {
        SecurityCredentials internalCred = this.callCredentials.get(Thread.currentThread());
        if (internalCred == null) {
            return this.getContainerCredentials();
        }
        return internalCred;
    }

    public void associateCurrentCredentials(Stub stub) {
        this.logger.debug("Adding the current security credentials");
        stub._setProperty("org.globus.gsi.credentials", this.getCredentials().getCredentialsAsObject());
        this.logger.debug("Security credentials added");
    }
}

