/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security;

import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class WSSecurityException
extends RemoteException {
    public static final int FAILURE = 0;
    public static final int UNSUPPORTED_SECURITY_TOKEN = 1;
    public static final int UNSUPPORTED_ALGORITHM = 2;
    public static final int INVALID_SECURITY = 3;
    public static final int INVALID_SECURITY_TOKEN = 4;
    public static final int FAILED_AUTHENTICATION = 5;
    public static final int FAILED_CHECK = 6;
    public static final int SECURITY_TOKEN_UNAVAILABLE = 7;
    public static final int FAILED_ENC_DEC = 8;
    public static final int FAILED_SIGNATURE = 9;
    private static ResourceBundle resources;
    private int errorCode;

    public WSSecurityException(int errorCode, String msgId, Object[] args, Throwable exception) {
        super(WSSecurityException.getMessage(errorCode, msgId, args), exception);
        this.errorCode = errorCode;
    }

    public WSSecurityException(int errorCode, String msgId, Object[] args) {
        super(WSSecurityException.getMessage(errorCode, msgId, args));
        this.errorCode = errorCode;
    }

    public WSSecurityException(int errorCode, String msgId) {
        this(errorCode, msgId, null);
    }

    public WSSecurityException(int errorCode) {
        this(errorCode, null, null);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    private static String getMessage(int errorCode, String msgId, Object[] args) {
        String msg = null;
        try {
            msg = resources.getString(String.valueOf(errorCode));
            if (msgId != null) {
                msg = msg + " (" + MessageFormat.format(resources.getString(msgId), args) + ")";
                return msg;
            }
        }
        catch (MissingResourceException e) {
            throw new RuntimeException("Undefined '" + msgId + "' resource property");
        }
        return msg;
    }

    static {
        try {
            resources = ResourceBundle.getBundle("org.apache.ws.security.errors");
        }
        catch (MissingResourceException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

