/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.trust2.serialization;

import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.message.RPCElement;
import org.apache.axis.message.RPCParam;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.server.AxisServer;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.trust2.RequestSecurityTokenResponse;
import org.apache.ws.security.trust2.SecurityTokenOrReference;
import org.apache.ws.security.trust2.TokenTypes;
import org.apache.ws.security.trust2.TrustConstants;
import org.apache.ws.security.trust2.serialization.RSTResponseDeserializerFactory;
import org.apache.ws.security.trust2.serialization.RSTResponseSerializerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class TestSerialization {
    static /* synthetic */ Class class$org$apache$ws$security$trust2$RequestSecurityTokenResponse;

    public static void main(String[] args) throws Exception {
        MessageContext msgContext = new MessageContext(new AxisServer());
        SOAPEnvelope msg = new SOAPEnvelope();
        RPCParam arg1 = new RPCParam("urn:myNamespace", "testParam", (Object)"this is a string");
        Document doc = msg.getAsDocument();
        UsernameToken userToken = new UsernameToken(WSSConfig.getDefaultWSConfig(), doc);
        userToken.setName("bob");
        userToken.setPassword("bobspass");
        RequestSecurityTokenResponse tokenResponse = new RequestSecurityTokenResponse(doc, new SecurityTokenOrReference(userToken));
        tokenResponse.setContext(new URI("http://context.context"));
        tokenResponse.setTokenType(TokenTypes.USERNAME);
        RPCParam arg2 = new RPCParam("", "struct", tokenResponse);
        RPCElement body = new RPCElement("urn:myNamespace", "method1", new Object[]{arg1, arg2});
        msg.addBodyElement(body);
        try {
            RequestSecurityTokenResponse val;
            Reader reader = null;
            if (args.length == 0) {
                StringWriter stringWriter = new StringWriter();
                SerializationContext context = new SerializationContext(stringWriter, msgContext);
                TypeMappingRegistry reg = context.getTypeMappingRegistry();
                TypeMapping tm = (TypeMapping)reg.getTypeMapping("http://schemas.xmlsoap.org/soap/encoding/");
                if (tm == null) {
                    tm = (TypeMapping)reg.createTypeMapping();
                    reg.register(Constants.URI_DEFAULT_SOAP_ENC, tm);
                }
                tm.register(class$org$apache$ws$security$trust2$RequestSecurityTokenResponse == null ? (class$org$apache$ws$security$trust2$RequestSecurityTokenResponse = TestSerialization.class$("org.apache.ws.security.trust2.RequestSecurityTokenResponse")) : class$org$apache$ws$security$trust2$RequestSecurityTokenResponse, TrustConstants.RESPONSE_NAME, new RSTResponseSerializerFactory(), new RSTResponseDeserializerFactory());
                msg.output(context);
                String msgString = ((Object)stringWriter).toString();
                System.out.println("Serialized msg:");
                System.out.println(msgString);
                System.out.println("-------");
                System.out.println("Testing deserialization...");
                reader = new StringReader(msgString);
            } else {
                reader = new FileReader(args[0]);
            }
            DeserializationContext dser = new DeserializationContext(new InputSource(reader), msgContext, "request");
            dser.parse();
            SOAPEnvelope env = dser.getEnvelope();
            RPCElement rpcElem = (RPCElement)env.getFirstBody();
            RPCParam struct = rpcElem.getParam("struct");
            if (struct == null) {
                throw new Exception("No <struct> param");
            }
            if (!(struct.getObjectValue() instanceof RequestSecurityTokenResponse)) {
                System.out.println("Not a RST object! ");
                System.out.println(struct.getValue());
                System.exit(1);
            }
            if ((val = (RequestSecurityTokenResponse)struct.getObjectValue()) == null) {
                throw new Exception("No value for struct param");
            }
            System.out.println(val.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

