/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.client;

import java.io.FileInputStream;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.message.addressing.ReferencePropertiesType;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.globus.axis.util.Util;
import org.globus.gsi.CertUtil;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.globus.wsrf.impl.security.authentication.Constants;
import org.globus.wsrf.impl.security.authentication.encryption.EncryptionCredentials;
import org.globus.wsrf.impl.security.authorization.HostAuthorization;
import org.globus.wsrf.impl.security.authorization.IdentityAuthorization;
import org.globus.wsrf.impl.security.authorization.NoAuthorization;
import org.globus.wsrf.impl.security.authorization.SelfAuthorization;
import org.xml.sax.InputSource;

public abstract class BaseClient {
    public static final int COMMAND_LINE_ERROR = 1;
    public static final int APPLICATION_ERROR = 2;
    protected EndpointReferenceType endpoint;
    protected boolean debugMode;
    protected String customUsage;
    protected String helpFooter;
    protected String helpHeader;
    protected Options options = new Options();
    protected String mechanism;
    protected Object protection = Constants.SIGNATURE;
    protected Object delegation;
    protected Object authorization;
    protected Object anonymous;
    protected Integer contextLifetime;
    protected String msgActor;
    protected String convActor;
    protected String publicKeyFilename;
    protected String descriptorFile;
    static final String AUTHZ_DESC = "Sets authorization, can be 'self', 'host', 'none' or a string specifying the expected identity of the remote party";
    static final String MECHANISM_DESC = "Sets authentication mechanism: 'msg' (for GSI Secure Message), or 'conv' (for GSI Secure Conversation)";
    static final String PROTECTION_DESC = "Sets protection level, can be 'sig' (for signature)  can be 'enc' (for encryption)";
    static final String ANON_DESC = "Use anonymous authentication (requires either -m 'conv' or transport (https) security)";
    static final String FILENAME_DESC = "A file with server's certificate used for encryption. Used in the case of GSI Secure Message encryption";
    static final String CONTEXT_DESC = "Lifetime of context created for GSI Secure Conversation (requires -m 'conv')";
    static final String MSG_ACTOR_DESC = "Sets actor name for GSI Secure Message";
    static final String CONV_ACTOR_DESC = "Sets actor name for GSI Secure Conversation";
    static final String DELEG_DESC = "Performs delegation. Can be 'limited' or 'full'. (requires -m 'conv')";
    static final String DESCRIPTOR_DESC = "Sets client security descriptor. Overrides all other security settings";
    private static final Option HELP;
    public static final Option EPR_FILE;
    public static final Option SERVICE_URL;
    public static final Option RESOURCE_KEY;
    public static final Option DEBUG;
    public static final Option AUTHZ;
    public static final Option MECHANISM;
    public static final Option ANON;
    public static final Option PROTECTION;
    public static final Option PUB_KEY_FILE;
    public static final Option CONTEXT;
    public static final Option MSG_ACTOR;
    public static final Option CONV_ACTOR;
    public static final Option DELEG;
    public static final Option DESCRIPTOR;

    protected BaseClient() {
        this.options.addOption(HELP);
        this.options.addOption(EPR_FILE);
        this.options.addOption(SERVICE_URL);
        this.options.addOption(RESOURCE_KEY);
        this.options.addOption(DEBUG);
        this.options.addOption(DESCRIPTOR);
        this.options.addOption(MECHANISM);
        this.options.addOption(ANON);
        this.options.addOption(PROTECTION);
        this.options.addOption(AUTHZ);
        this.options.addOption(CONTEXT);
        this.options.addOption(DELEG);
        this.options.addOption(PUB_KEY_FILE);
    }

    public void setCustomUsage(String customUsage) {
        this.customUsage = customUsage;
    }

    public void setHelpFooter(String msg) {
        this.helpFooter = msg;
    }

    public void setHelpHeader(String msg) {
        this.helpHeader = msg;
    }

    public void displayUsage() {
        String usage = "java " + this.getClass().getName() + " [-h] [-s url [-k name value] | -e file] ";
        usage = this.customUsage == null ? usage : usage + this.customUsage;
        String header = this.helpHeader == null ? "Options:" : this.helpHeader;
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(usage, header, this.options, null, false);
        if (this.helpFooter != null) {
            System.out.println(this.helpFooter);
        }
    }

    protected CommandLine parse(String[] args) throws Exception {
        return this.parse(args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CommandLine parse(String[] args, Properties defaultOptions) throws Exception {
        String value;
        PosixParser parser = new PosixParser();
        CommandLine line = parser.parse(this.options, args, defaultOptions);
        if (defaultOptions != null) {
            Iterator<Map.Entry<Object, Object>> iter = defaultOptions.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Object, Object> entry = iter.next();
                Option opt = this.options.getOption((String)entry.getKey());
                if (opt == null) continue;
                String desc = opt.getDescription();
                desc = desc + " (Default '" + entry.getValue() + "')";
                opt.setDescription(desc);
            }
        }
        if (line.hasOption("h")) {
            this.displayUsage();
            System.exit(0);
        }
        if (line.hasOption("e")) {
            if (line.hasOption("k")) {
                throw new ParseException("-e and -k arguments are exclusive");
            }
            if (line.hasOption("s")) {
                throw new ParseException("-e and -s arguments are exclusive");
            }
            FileInputStream in = null;
            try {
                in = new FileInputStream(line.getOptionValue("e"));
                this.endpoint = (EndpointReferenceType)ObjectDeserializer.deserialize(new InputSource(in), EndpointReferenceType.class);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        if (line.hasOption("s")) {
            this.endpoint = new EndpointReferenceType();
            this.endpoint.setAddress(new Address(line.getOptionValue("s")));
        } else {
            throw new ParseException("-s or -e argument is required");
        }
        if (line.hasOption("k")) {
            String[] values = line.getOptionValues("k");
            if (values.length != 2) {
                throw new ParseException("-k requires two arguments");
            }
            QName keyName = QName.valueOf(values[0]);
            ReferencePropertiesType props = new ReferencePropertiesType();
            SimpleResourceKey key = new SimpleResourceKey(keyName, values[1]);
            props.add(key.toSOAPElement());
            this.endpoint.setProperties(props);
        }
        this.debugMode = line.hasOption("d");
        if (line.hasOption("m") && (value = line.getOptionValue("m")) != null) {
            if (value.equals("msg")) {
                this.mechanism = "org.globus.security.secMsg.msg.type";
            } else if (value.equals("conv")) {
                this.mechanism = "org.globus.security.secConv.msg.type";
            } else {
                throw new ParseException("Unsupported security mechanism: " + value);
            }
        }
        if (line.hasOption("p") && (value = line.getOptionValue("p")) != null) {
            if (value.equals("sig")) {
                this.protection = Constants.SIGNATURE;
            } else if (value.equals("enc")) {
                this.protection = Constants.ENCRYPTION;
            } else {
                throw new ParseException("Unsupported protection mode: " + value);
            }
        }
        if (line.hasOption("g") && (value = line.getOptionValue("g")) != null) {
            if (value.equals("limited")) {
                this.delegation = "gsilimited";
            } else if (value.equals("full")) {
                this.delegation = "gsifull";
            } else {
                throw new ParseException("Unsupported delegation mode: " + value);
            }
        }
        if (line.hasOption("z") && (value = line.getOptionValue("z")) != null) {
            if (value.equals("self")) {
                this.authorization = SelfAuthorization.getInstance();
            } else if (value.equals("host")) {
                this.authorization = HostAuthorization.getInstance();
            } else if (value.equals("none")) {
                this.authorization = NoAuthorization.getInstance();
            } else if (this.authorization == null) {
                this.authorization = new IdentityAuthorization(value);
            }
        }
        if (line.hasOption("a")) {
            this.anonymous = Boolean.TRUE;
        }
        if (line.hasOption("l") && (value = line.getOptionValue("l")) != null) {
            this.contextLifetime = new Integer(value);
        }
        if (line.hasOption("x")) {
            this.msgActor = value = line.getOptionValue("x");
        }
        if (line.hasOption("y")) {
            this.convActor = value = line.getOptionValue("y");
        }
        if (line.hasOption("c")) {
            this.publicKeyFilename = value = line.getOptionValue("c");
        }
        if (line.hasOption("f")) {
            this.descriptorFile = value = line.getOptionValue("f");
        }
        return line;
    }

    public void setOptions(Stub stub) throws Exception {
        if (this.descriptorFile != null) {
            stub._setProperty("clientDescriptorFile", this.descriptorFile);
            return;
        }
        if (this.protection != null) {
            if (this.endpoint.getAddress().getScheme().equals("https")) {
                stub._setProperty("org.globus.security.transport.type", this.protection);
            }
            if (this.mechanism != null) {
                stub._setProperty(this.mechanism, this.protection);
            }
        }
        if (this.convActor != null) {
            stub._setProperty("gssActor", this.convActor);
        }
        if (this.delegation != null) {
            stub._setProperty("org.globus.gsi.mode", this.delegation);
        }
        if (this.authorization != null) {
            stub._setProperty("org.globus.security.authorization", this.authorization);
        }
        if (this.anonymous != null) {
            stub._setProperty("org.globus.gsi.anonymous", this.anonymous);
        }
        if (this.msgActor != null) {
            stub._setProperty("x509Actor", this.msgActor);
        }
        if ("org.globus.security.secMsg.msg.type".equals(this.mechanism) && Constants.ENCRYPTION.equals(this.protection)) {
            Subject subject = new Subject();
            X509Certificate serverCert = CertUtil.loadCertificate(this.publicKeyFilename);
            EncryptionCredentials encryptionCreds = new EncryptionCredentials(new X509Certificate[]{serverCert});
            subject.getPublicCredentials().add(encryptionCreds);
            stub._setProperty("callerSubject", subject);
        }
        if (this.contextLifetime != null) {
            stub._setProperty("org.globus.security.context.lifetime", this.contextLifetime);
        }
    }

    public EndpointReferenceType getEPR() {
        return this.endpoint;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    static {
        OptionBuilder.withDescription("Displays help");
        OptionBuilder.withLongOpt("help");
        HELP = OptionBuilder.create("h");
        OptionBuilder.withArgName("file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Loads EPR from file");
        OptionBuilder.withLongOpt("eprFile");
        EPR_FILE = OptionBuilder.create("e");
        OptionBuilder.withArgName("url");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Service URL");
        OptionBuilder.withLongOpt("service");
        SERVICE_URL = OptionBuilder.create("s");
        OptionBuilder.withArgName("name value");
        OptionBuilder.hasArgs(2);
        OptionBuilder.withDescription("Resource Key");
        OptionBuilder.withLongOpt("key");
        RESOURCE_KEY = OptionBuilder.create("k");
        OptionBuilder.withDescription("Enables debug mode");
        OptionBuilder.withLongOpt("debug");
        DEBUG = OptionBuilder.create("d");
        OptionBuilder.withArgName("type");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription(AUTHZ_DESC);
        OptionBuilder.withLongOpt("authorization");
        AUTHZ = OptionBuilder.create("z");
        OptionBuilder.withArgName("type");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription(MECHANISM_DESC);
        OptionBuilder.withLongOpt("securityMech");
        MECHANISM = OptionBuilder.create("m");
        OptionBuilder.withDescription(ANON_DESC);
        OptionBuilder.withLongOpt("anonymous");
        ANON = OptionBuilder.create("a");
        OptionBuilder.withArgName("type");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription(PROTECTION_DESC);
        OptionBuilder.withLongOpt("protection");
        PROTECTION = OptionBuilder.create("p");
        OptionBuilder.withArgName("file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription(FILENAME_DESC);
        OptionBuilder.withLongOpt("serverCertificate");
        OptionBuilder.hasOptionalArg();
        PUB_KEY_FILE = OptionBuilder.create("c");
        OptionBuilder.withArgName("value");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription(CONTEXT_DESC);
        OptionBuilder.withLongOpt("contextLifetime");
        CONTEXT = OptionBuilder.create("l");
        OptionBuilder.withArgName("actor");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription(MSG_ACTOR_DESC);
        OptionBuilder.withLongOpt("gsiSecMsgActor");
        MSG_ACTOR = OptionBuilder.create("x");
        OptionBuilder.withArgName("actor");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription(CONV_ACTOR_DESC);
        OptionBuilder.withLongOpt("gsiSecConvActor");
        CONV_ACTOR = OptionBuilder.create("y");
        OptionBuilder.withArgName("mode");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription(DELEG_DESC);
        OptionBuilder.withLongOpt("delegation");
        DELEG = OptionBuilder.create("g");
        OptionBuilder.withDescription(DESCRIPTOR_DESC);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("file");
        OptionBuilder.withLongOpt("descriptor");
        DESCRIPTOR = OptionBuilder.create("f");
        Util.registerTransport();
    }
}

