/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtils {
    private static Log log = LogFactory.getLog(XmlUtils.class.getName());
    private static DocumentBuilderFactory dbf = XmlUtils.getDOMFactory();

    private static DocumentBuilderFactory getDOMFactory() {
        DocumentBuilderFactory dbf;
        try {
            dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
        }
        catch (Exception e) {
            log.error("", e);
            dbf = null;
        }
        return dbf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document newDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = dbf;
        synchronized (documentBuilderFactory) {
            return dbf.newDocumentBuilder().newDocument();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document newDocument(InputSource inp) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder db;
        DocumentBuilderFactory documentBuilderFactory = dbf;
        synchronized (documentBuilderFactory) {
            db = dbf.newDocumentBuilder();
        }
        db.setErrorHandler(new XMLUtils.ParserErrorHandler());
        return db.parse(inp);
    }

    public static Document newDocument(InputStream inp) throws ParserConfigurationException, SAXException, IOException {
        return XmlUtils.newDocument(new InputSource(inp));
    }

    public static Document newDocument(String uri) throws ParserConfigurationException, SAXException, IOException {
        return XmlUtils.newDocument(uri, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document newDocument(String uri, String username, String password) throws ParserConfigurationException, SAXException, IOException {
        InputSource ins = XmlUtils.getInputSourceFromURI(uri, username, password);
        Document doc = null;
        try {
            doc = XmlUtils.newDocument(ins);
        }
        finally {
            if (ins.getByteStream() != null) {
                ins.getByteStream().close();
            } else if (ins.getCharacterStream() != null) {
                ins.getCharacterStream().close();
            }
        }
        return doc;
    }

    private static InputSource getInputSourceFromURI(String uri, String username, String password) throws IOException {
        URL wsdlurl = null;
        try {
            wsdlurl = new URL(uri);
        }
        catch (MalformedURLException e) {
            return new InputSource(uri);
        }
        if (username == null && wsdlurl.getUserInfo() == null) {
            return new InputSource(uri);
        }
        if (!wsdlurl.getProtocol().startsWith("http")) {
            return new InputSource(uri);
        }
        URLConnection connection = wsdlurl.openConnection();
        if (!(connection instanceof HttpURLConnection)) {
            return new InputSource(uri);
        }
        HttpURLConnection uconn = (HttpURLConnection)connection;
        String userinfo = wsdlurl.getUserInfo();
        uconn.setRequestMethod("GET");
        uconn.setAllowUserInteraction(false);
        uconn.setDefaultUseCaches(false);
        uconn.setDoInput(true);
        uconn.setDoOutput(false);
        uconn.setInstanceFollowRedirects(true);
        uconn.setUseCaches(false);
        String auth = null;
        if (userinfo != null) {
            auth = userinfo;
        } else if (username != null) {
            String string = auth = password == null ? username : username + ":" + password;
        }
        if (auth != null) {
            uconn.setRequestProperty("Authorization", "Basic " + XMLUtils.base64encode(auth.getBytes(XMLUtils.getEncoding())));
        }
        uconn.connect();
        return new InputSource(uconn.getInputStream());
    }

    public static String toString(Document doc) {
        return XMLUtils.DocumentToString(doc);
    }

    public static String toString(Element element) {
        return XMLUtils.ElementToString(element);
    }

    public static Element getFirstChildElement(Element element) {
        for (Node currentChild = element.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (currentChild.getNodeType() != 1) continue;
            return (Element)currentChild;
        }
        return null;
    }
}

