/*
 * Decompiled with CFR 0.152.
 */
package ise.library;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class GUIUtils {
    public static void center(Component me, Component you) {
        int y;
        Rectangle my = me.getBounds();
        Dimension your = you.getSize();
        int x = my.x + (my.width - your.width) / 2;
        if (x < 0) {
            x = 0;
        }
        if ((y = my.y + (my.height - your.height) / 2) < 0) {
            y = 0;
        }
        you.setLocation(x, y);
    }

    public static void centerOnScreen(Component me) {
        Dimension screen_size = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension window_size = me.getSize();
        me.setBounds((screen_size.width - window_size.width) / 2, (screen_size.height - window_size.height) / 2, window_size.width, window_size.height);
    }

    public static void fillScreen(Component frame) {
        String version = System.getProperty("java.version");
        if ((version.startsWith("1.4") || version.startsWith("1.5")) && frame instanceof Frame) {
            ((Frame)frame).setExtendedState(6);
            return;
        }
        Dimension screen_size = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setSize(screen_size);
        GUIUtils.centerOnScreen(frame);
    }

    public static Frame getRootFrame(Component c) {
        Container parent = c.getParent();
        while (parent != null) {
            if (parent instanceof Frame) {
                return (Frame)parent;
            }
            parent = ((Component)parent).getParent();
        }
        return null;
    }

    public static JFrame getRootJFrame(Component c) {
        Container parent = c.getParent();
        while (parent != null) {
            if (parent instanceof JFrame) {
                return (JFrame)parent;
            }
            parent = ((Component)parent).getParent();
        }
        return null;
    }

    public static Window getRootWindow(Component c) {
        Container parent = c.getParent();
        while (parent != null) {
            if (parent instanceof Window) {
                return (Window)parent;
            }
            parent = ((Component)parent).getParent();
        }
        return null;
    }

    public static Point getBestAnchorPoint(Component comp, int x, int y) {
        int new_x = x;
        int new_y = y;
        Point p = new Point(new_x, new_y);
        SwingUtilities.convertPointToScreen(p, comp);
        Dimension size = comp.getSize();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        boolean move_horizontally = false;
        boolean move_vertically = false;
        if (p.x + size.width > screen.width && size.width < screen.width) {
            new_x += screen.width - p.x - size.width;
            move_horizontally = true;
        }
        if (p.y + size.height > screen.height && size.height < screen.height) {
            new_y += screen.height - p.y - size.height;
            move_vertically = true;
        }
        if (move_horizontally && move_vertically && comp instanceof JPopupMenu) {
            if (x - size.width - 2 > 0) {
                new_x = x - size.width - 2;
            } else if (y - size.height - 2 > 0) {
                new_y = y - size.height - 2;
            }
        }
        return new Point(new_x, new_y);
    }

    public static void showPopupMenu(JPopupMenu popup, Component comp, int x, int y) {
        Point p = GUIUtils.getBestAnchorPoint(comp, x, y);
        popup.show(comp, p.x, p.y);
    }
}

