/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.util.ArrayList;
import java.util.Iterator;
import nu.xom.Attribute;
import nu.xom.NamespaceConflictException;
import nu.xom.NoSuchAttributeException;

final class Attributes {
    private ArrayList attributes = new ArrayList(1);

    Attributes() {
    }

    int size() {
        return this.attributes.size();
    }

    Attribute get(int n) {
        return (Attribute)this.attributes.get(n);
    }

    void add(Attribute attribute) {
        this.checkPrefixConflict(attribute);
        Attribute attribute2 = this.get(attribute.getLocalName(), attribute.getNamespaceURI());
        if (attribute2 != null) {
            this.remove(attribute2);
        }
        this.attributes.add(attribute);
    }

    void checkPrefixConflict(Attribute attribute) {
        String string = attribute.getNamespacePrefix();
        String string2 = attribute.getNamespaceURI();
        Iterator iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            Attribute attribute2 = (Attribute)iterator.next();
            if (!attribute2.getNamespacePrefix().equals(string) || attribute2.getNamespaceURI().equals(string2)) continue;
            throw new NamespaceConflictException("Prefix of " + attribute.getQualifiedName() + " conflicts with " + attribute2.getQualifiedName());
        }
    }

    void remove(Attribute attribute) {
        if (attribute == null) {
            throw new NullPointerException("Tried to remove null attribute");
        }
        boolean bl = this.attributes.remove(attribute);
        if (!bl) {
            throw new NoSuchAttributeException("Tried to remove attribute " + attribute.getQualifiedName() + " from non-parent element");
        }
    }

    Attribute get(String string, String string2) {
        Iterator iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (!attribute.getLocalName().equals(string) || !attribute.getNamespaceURI().equals(string2)) continue;
            return attribute;
        }
        return null;
    }

    Attributes copy() {
        Attributes attributes = new Attributes();
        attributes.attributes.ensureCapacity(this.size());
        for (int i = 0; i < this.attributes.size(); ++i) {
            attributes.attributes.add(this.get(i).copy());
        }
        return attributes;
    }
}

