/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.axis.security.trust.secconv.interop;

import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.axis.utils.DOM2Writer;
import org.apache.ws.axis.security.trust.secconv.interop.InteropUtil;
import org.apache.ws.axis.security.trust.secconv.interop.SAML2SCTRequester;
import org.apache.ws.axis.security.trust.secconv.interop.UNT2SAMLRequester;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.conversation.DerivedKeyCallbackHandler;
import org.apache.ws.security.conversation.message.info.SecurityContextInfo;
import org.apache.ws.security.conversation.message.token.RequestSecurityTokenResponse;
import org.apache.ws.security.conversation.message.token.RequestedSecurityToken;
import org.apache.ws.security.conversation.message.token.SecurityContextToken;
import org.apache.ws.security.trust.RSTR_Parser;
import org.apache.ws.security.trust.WSTrustException;
import org.apache.ws.security.util.Loader;
import org.apache.ws.security.util.WSSecurityUtil;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InteropHandshaker {
    private DerivedKeyCallbackHandler dkcb = null;
    private String uuid = null;
    Hashtable options = null;

    public void handshake(Hashtable opt) {
        this.loadProperties("interop_Data.properties");
        String serviceViaTCPMon = (String)this.options.get("serviceViaTCPMon");
        String ipViaTCMPMon = (String)this.options.get("ipViaTCMPMon");
        String realIPAddress = (String)this.options.get("realIPAddress");
        String realServiceAddress = (String)this.options.get("realServiceAddress");
        System.out.println(serviceViaTCPMon);
        System.out.println(ipViaTCMPMon);
        System.out.println(realIPAddress);
        System.out.println(realServiceAddress);
        try {
            UNT2SAMLRequester initReq = new UNT2SAMLRequester();
            initReq.setRealIPAddressReal(realIPAddress);
            initReq.setRealServiceAddress(realServiceAddress);
            initReq.setIpViaTCMPMon(ipViaTCMPMon);
            initReq.peformRST(opt);
            RSTR_Parser parser = null;
            parser = initReq.getParser();
            Element samlEle = (Element)WSSecurityUtil.getDirectChild(parser.getReqtedTok().getElement(), "Assertion", "urn:oasis:names:tc:SAML:1.0:assertion");
            SAMLAssertion saml = new SAMLAssertion(samlEle);
            System.out.println(DOM2Writer.nodeToString(samlEle, true));
            System.out.println("Second request....");
            SAML2SCTRequester secondReq = new SAML2SCTRequester();
            secondReq.setRealServiceAddress(realServiceAddress);
            secondReq.setServiceViaTCMPMon(serviceViaTCPMon);
            secondReq.setRealIPAddressReal(realIPAddress);
            secondReq.setSaml(saml);
            secondReq.peformRST(opt);
            String key1 = initReq.getRequestNonce();
            String key2 = parser.getBinSecret().getBinarySecretValue();
            byte[] key = InteropUtil.generateSymmetricFromEntropy(key1, key2);
            String tempUUID = saml.getId();
            SecurityContextInfo sctInfo = new SecurityContextInfo(tempUUID, key, 1);
            DerivedKeyCallbackHandler dkcbHandler = new DerivedKeyCallbackHandler();
            DerivedKeyCallbackHandler.addSecurtiyContext(tempUUID, sctInfo);
            secondReq.createSecurityHeader(dkcbHandler, tempUUID);
            Document resSCTdoc = secondReq.getDocRes();
            RSTR_Parser sec_Pars = new RSTR_Parser();
            Element rstrEle = (Element)resSCTdoc.getElementsByTagNameNS("http://schemas.xmlsoap.org/ws/2004/04/trust", "RequestSecurityTokenResponse").item(0);
            sec_Pars.processRSTR(new RequestSecurityTokenResponse(rstrEle));
            RequestedSecurityToken secondTok = sec_Pars.getReqtedTok();
            Element sctEle = (Element)secondTok.getElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/ws/2004/04/sc", "SecurityContextToken").item(0);
            SecurityContextToken sct = new SecurityContextToken(sctEle);
            String stringKey = sec_Pars.getBinSecret().getBinarySecretValue();
            byte[] keyByte = stringKey.getBytes();
            SecurityContextInfo info = new SecurityContextInfo(sct, keyByte, 1);
            System.out.println("UUID is ::: :-)" + this.uuid);
            this.uuid = sct.getIdentifier();
            this.dkcb = new DerivedKeyCallbackHandler();
            DerivedKeyCallbackHandler.addSecurtiyContext(this.uuid, info);
        }
        catch (WSSecurityException e) {
            e.printStackTrace();
        }
        catch (SAMLException e1) {
            e1.printStackTrace();
        }
        catch (WSTrustException e1) {
            e1.printStackTrace();
        }
        catch (NoSuchAlgorithmException e2) {
            e2.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DerivedKeyCallbackHandler getDkcb() {
        return this.dkcb;
    }

    public void setDkcb(DerivedKeyCallbackHandler handler) {
        this.dkcb = handler;
    }

    public String getUuid() {
        return this.uuid;
    }

    private void loadProperties(String propFilename) {
        Properties properties = new Properties();
        try {
            URL url = Loader.getResource(propFilename);
            properties.load(url.openStream());
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load properties: " + propFilename);
        }
        this.options = new Hashtable();
        Enumeration<Object> enumKeys = properties.keys();
        while (enumKeys.hasMoreElements()) {
            String key = (String)enumKeys.nextElement();
            this.options.put(key, properties.getProperty(key));
        }
    }
}

