/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.trust.message.token;

import javax.xml.namespace.QName;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.trust.message.token.Code;
import org.apache.ws.security.trust.message.token.Reason;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Status {
    public static final QName TOKEN = new QName("http://schemas.xmlsoap.org/ws/2004/04/trust", "Status", "wst");
    Element element = null;

    public Status(Element elem) throws WSSecurityException {
        this.element = elem;
        QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
        if (!el.equals(TOKEN)) {
            throw new WSSecurityException(4, "badTokenType", new Object[]{el});
        }
    }

    public Status(Document doc) {
        this.element = doc.createElementNS(TOKEN.getNamespaceURI(), TOKEN.getPrefix() + ":" + TOKEN.getLocalPart());
        WSSecurityUtil.setNamespace(this.element, "http://schemas.xmlsoap.org/ws/2004/04/trust", "wst");
        this.element.appendChild(doc.createTextNode(""));
    }

    public void setCode(Code code) {
        this.element.appendChild(code.getElement());
    }

    public Code getCode() throws WSSecurityException {
        Element elem = (Element)WSSecurityUtil.findElement(this.element, Code.TOKEN.getLocalPart(), Code.TOKEN.getNamespaceURI());
        return new Code(elem);
    }

    public void setReason(Reason reason) {
        this.element.appendChild(reason.getElement());
    }

    public Reason getReason() throws WSSecurityException {
        Element elem = (Element)WSSecurityUtil.findElement(this.element, Reason.TOKEN.getLocalPart(), Reason.TOKEN.getNamespaceURI());
        return new Reason(elem);
    }

    public Element getFirstElement() {
        for (Node currentChild = this.element.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (!(currentChild instanceof Element)) continue;
            return (Element)currentChild;
        }
        return null;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }
}

