/*
 * Decompiled with CFR 0.152.
 */
package org.globus.axis.transport.commons;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.globus.axis.transport.SSLContextHelper;
import org.globus.common.ChainedIOException;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.net.SocketFactory;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

public class CommonsSSLSocketFactory
implements ProtocolSocketFactory {
    private SocketFactory defaultSocketFactory = SocketFactory.getDefault();

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        throw new IOException("not supported");
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        throw new IOException("not supported");
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        SSLContextHelper helper = null;
        Authorization authz = null;
        Boolean anonymous = null;
        GSSCredential cred = null;
        Integer protection = null;
        TrustedCertificates trustedCerts = null;
        if (params != null) {
            authz = (Authorization)params.getParameter("org.globus.gsi.authorization");
            anonymous = (Boolean)params.getParameter("org.globus.gsi.anonymous");
            cred = (GSSCredential)params.getParameter("org.globus.gsi.credentials");
            protection = (Integer)params.getParameter("org.globus.security.transport.type");
            trustedCerts = (TrustedCertificates)params.getParameter("org.globus.security.trustedCertifictes");
        }
        try {
            helper = new SSLContextHelper(host, port, authz, anonymous, cred, protection, trustedCerts);
        }
        catch (GSSException e) {
            throw new ChainedIOException("Failed to initialize security context", e);
        }
        Socket socket = this.defaultSocketFactory.createSocket(host, port, localAddress, localPort);
        return helper.wrapSocket(socket);
    }
}

