/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.container;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Iterator;
import javax.security.auth.Subject;
import org.apache.axis.AxisEngine;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.MessageContext;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.server.AxisServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.axis.description.ServiceDescUtil;
import org.globus.gsi.jaas.JaasSubject;
import org.globus.util.I18n;
import org.globus.wsrf.NoResourceHomeException;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.container.ContainerException;
import org.globus.wsrf.container.UsageConfig;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityConfig;
import org.globus.wsrf.jndi.JNDIUtils;
import org.globus.wsrf.security.SecurityManager;
import org.globus.wsrf.utils.Resources;

public class ServiceManager {
    public static final String LOAD_STARTUP_PARAM = "loadOnStartup";
    private static I18n i18n = I18n.getI18n(Resources.class.getName());
    private static Log logger = LogFactory.getLog(ServiceManager.class.getName());
    private static Hashtable managers = new Hashtable();
    private AxisServer engine;
    private WSDDDeployment deployment;
    private MessageContext ctx;
    private UsageConfig monitor;
    private static final String INITIALIZED = "org.globus.wsrf.container.service.initialized";

    public ServiceManager(AxisServer engine) {
        if (engine == null) {
            throw new IllegalArgumentException();
        }
        this.engine = engine;
        EngineConfiguration config = this.engine.getConfig();
        if (!(config instanceof WSDDEngineConfiguration)) {
            throw new IllegalArgumentException();
        }
        this.deployment = ((WSDDEngineConfiguration)config).getDeployment();
        this.monitor = new UsageConfig(this);
    }

    public static synchronized ServiceManager getServiceManager(AxisServer engine) {
        ServiceManager manager = (ServiceManager)managers.get(engine);
        if (manager == null) {
            manager = new ServiceManager(engine);
            managers.put(engine, manager);
        }
        return manager;
    }

    public static ServiceManager getCurrentServiceManager() {
        MessageContext ctx = MessageContext.getCurrentContext();
        if (ctx == null) {
            return null;
        }
        AxisEngine engine = ctx.getAxisEngine();
        return engine instanceof AxisServer ? ServiceManager.getServiceManager((AxisServer)engine) : null;
    }

    public UsageConfig getUsageConfig() {
        return this.monitor;
    }

    AxisServer getAxisEngine() {
        return this.engine;
    }

    WSDDService[] getServices() {
        return this.deployment.getServices();
    }

    String getOption(String key) {
        return this.deployment.getGlobalConfiguration() != null ? this.deployment.getGlobalConfiguration().getParameter(key) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(MessageContext msgCtx) throws Exception {
        logger.debug("Starting engine: " + this.engine);
        this.ctx = msgCtx;
        JNDIUtils.initializeDir(msgCtx);
        WSDDService[] services = this.deployment.getServices();
        MessageContext oldCtx = HelperAxisEngine.getCurrentMessageContext();
        HelperAxisEngine.setCurrentMessageContext(msgCtx);
        try {
            for (int i = 0; i < services.length; ++i) {
                if (!"true".equalsIgnoreCase(services[i].getParameter(LOAD_STARTUP_PARAM))) continue;
                String serviceName = services[i].getQName().getLocalPart();
                msgCtx.setTargetService(serviceName);
                try {
                    ServiceManager.initializeService(msgCtx);
                    continue;
                }
                catch (Exception e) {
                    throw new ContainerException(i18n.getMessage("failedInitService", serviceName), e);
                }
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            HelperAxisEngine.setCurrentMessageContext(oldCtx);
            throw throwable;
        }
        HelperAxisEngine.setCurrentMessageContext(oldCtx);
        if (this.monitor.hasTargets()) {
            this.monitor.sendStartPacket();
        }
    }

    public MessageContext createMessageContext(String serviceName) throws Exception {
        MessageContext newCtx = new MessageContext(this.engine);
        Iterator iter = this.ctx.getAllPropertyNames();
        while (iter.hasNext()) {
            String propName = (String)iter.next();
            Object propValue = this.ctx.getProperty(propName);
            newCtx.setProperty(propName, propValue);
        }
        newCtx.setTargetService(serviceName);
        return newCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeService(MessageContext ctx) throws Exception {
        String serviceName = ctx.getTargetService();
        SOAPService service = ctx.getService();
        if (serviceName == null || service == null) {
            return;
        }
        ServiceDesc serviceDesc = service.getInitializedServiceDesc(ctx);
        if (ServiceManager.isServiceInitialized(serviceDesc)) {
            return;
        }
        ServiceDesc serviceDesc2 = serviceDesc;
        synchronized (serviceDesc2) {
            if (ServiceManager.isServiceInitialized(serviceDesc)) {
                return;
            }
            logger.debug("Activating service: " + serviceName);
            ServiceSecurityConfig.initialize(ctx);
            Subject subject = SecurityManager.getManager().getServiceSubject(serviceName);
            if (subject == null) {
                InitPrivilegedAction.initialize(ctx);
            } else {
                try {
                    JaasSubject.doAs(subject, new InitPrivilegedAction(ctx));
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }
            logger.debug("Activated service: " + serviceName);
            ServiceManager.setServiceInitialized(serviceDesc);
        }
    }

    public void stop() {
        logger.debug("Stopping engine: " + this.engine);
        managers.remove(this.engine);
        if (this.monitor.hasTargets()) {
            this.monitor.sendStopPacket();
        }
    }

    static boolean isServiceInitialized(ServiceDesc desc) {
        return desc.getProperty(INITIALIZED) != null;
    }

    static void setServiceInitialized(ServiceDesc desc) {
        desc.setProperty(INITIALIZED, Boolean.TRUE);
    }

    public static class HelperAxisEngine
    extends AxisEngine {
        public HelperAxisEngine() {
            super(null);
        }

        public void init() {
        }

        public AxisEngine getClientEngine() {
            return null;
        }

        public void invoke(MessageContext ctx) {
        }

        public static void setCurrentMessageContext(MessageContext mc) {
            AxisEngine.setCurrentMessageContext(mc);
        }
    }

    private static class InitPrivilegedAction
    implements PrivilegedExceptionAction {
        private MessageContext ctx = null;

        public InitPrivilegedAction(MessageContext ctx) {
            this.ctx = ctx;
        }

        public static void initialize(MessageContext ctx) throws Exception {
            ServiceDescUtil.initializeService(ctx);
            ResourceContext rctx = ResourceContext.getResourceContext(ctx);
            try {
                rctx.getResourceHome();
            }
            catch (NoResourceHomeException noResourceHomeException) {
                // empty catch block
            }
        }

        public Object run() throws Exception {
            InitPrivilegedAction.initialize(this.ctx);
            return null;
        }
    }
}

