/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication.wssec;

import java.security.Key;
import java.security.PrivateKey;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPEnvelope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.proxy.ProxyPathValidator;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceContextException;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.impl.security.authentication.Constants;
import org.globus.wsrf.impl.security.authentication.secureconv.service.SecurityContext;
import org.globus.wsrf.impl.security.authentication.wssec.GSSSecurityEngine;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityEngine;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityException;
import org.globus.wsrf.impl.security.descriptor.SecurityPropertiesHelper;
import org.globus.wsrf.providers.GSSPublicKey;
import org.globus.wsrf.security.SecurityManager;
import org.globus.wsrf.utils.ContextUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSSecurityRequestEngine
extends WSSecurityEngine {
    private static Log log = LogFactory.getLog(WSSecurityRequestEngine.class.getName());
    private static WSSecurityEngine engine;

    public static synchronized WSSecurityEngine getEngine() {
        if (engine == null) {
            engine = new WSSecurityRequestEngine();
        }
        return engine;
    }

    public Document processSecurityHeader(SOAPEnvelope env, MessageContext msgCtx) throws Exception {
        return this.processSecurityHeader(env, msgCtx, true);
    }

    public boolean verifyXMLSignature(XMLSignature sig, MessageContext msgCtx) throws Exception {
        ProxyPathValidator validator = new ProxyPathValidator();
        Resource resource = null;
        try {
            ResourceContext context = ResourceContext.getResourceContext((org.apache.axis.MessageContext)msgCtx);
            resource = context.getResource();
        }
        catch (ResourceContextException exp) {
            log.debug("Resource does not exist ", exp);
            resource = null;
        }
        catch (ResourceException exp) {
            log.debug("Resource does not exist ", exp);
            resource = null;
        }
        String servicePath = ContextUtils.getTargetServicePath((org.apache.axis.MessageContext)msgCtx);
        Boolean rejectLimState = SecurityPropertiesHelper.getRejectLimitedProxyState(servicePath, resource);
        if (Boolean.TRUE.equals(rejectLimState)) {
            log.debug("Reject Limited Proxy is true, service");
            validator.setRejectLimitedProxyCheck(true);
        }
        return this.verifyXMLSignature(sig, msgCtx, validator);
    }

    public boolean decryptXMLEncryption(Element element, MessageContext msgCtx) throws Exception {
        Iterator<Object> iterator;
        Set<Object> privateCreds;
        log.debug("Enter: decryptXMLEncryption");
        this.ensureSignature(msgCtx);
        PrivateKey key = null;
        SecurityManager manager = SecurityManager.getManager((org.apache.axis.MessageContext)msgCtx);
        Subject subject = manager.getSystemSubject();
        if (subject != null && (privateCreds = subject.getPrivateCredentials()) != null && (iterator = privateCreds.iterator()).hasNext()) {
            GlobusGSSCredentialImpl cred = (GlobusGSSCredentialImpl)iterator.next();
            key = cred.getPrivateKey();
        }
        if (key == null) {
            log.error("No credentials to decrypt");
            throw new WSSecurityException(0, "noCreds");
        }
        msgCtx.setProperty("org.globus.security.secMsg.msg.type", Constants.ENCRYPTION);
        return this.decryptXMLEncryption(element, key);
    }

    public boolean verifyGssXMLSignature(XMLSignature sig, MessageContext msgContext) throws Exception {
        log.debug("Enter: verifyGssXMLSignature");
        KeyInfo keyInfo = sig.getKeyInfo();
        boolean result = false;
        SecurityContext context = GSSSecurityEngine.getContext((org.apache.axis.MessageContext)msgContext, keyInfo);
        if (context == null) {
            throw new WSSecurityException(0, "noContext01");
        }
        result = sig.checkSignatureValue((Key)new GSSPublicKey((String)context.getID(), context.getContext()));
        this.setContextProperties(msgContext, context, Constants.SIGNATURE);
        log.debug("Exit: verifyGssXMLSignature");
        return result;
    }
}

