/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.descriptor;

import javax.xml.rpc.handler.MessageContext;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.authentication.Constants;
import org.globus.wsrf.impl.security.descriptor.AuthMethod;

public class GSISecureMsgAuthMethod
implements AuthMethod {
    private static I18n i18n = I18n.getI18n("org.globus.wsrf.impl.security.descriptor.errors");
    static final int BOTH_TYPE = 0;
    static final int INTEGRITY_TYPE = 1;
    static final int PRIVACY_TYPE = 2;
    private int type;
    public static final GSISecureMsgAuthMethod BOTH = new GSISecureMsgAuthMethod(0);
    public static final GSISecureMsgAuthMethod PRIVACY = new GSISecureMsgAuthMethod(2);
    public static final GSISecureMsgAuthMethod INTEGRITY = new GSISecureMsgAuthMethod(1);

    public GSISecureMsgAuthMethod(int type) {
        this.type = type;
    }

    public boolean isAuthenticated(MessageContext ctx) {
        switch (this.type) {
            case 0: {
                return Constants.SIGNATURE.equals(ctx.getProperty("org.globus.security.secMsg.msg.type")) || Constants.ENCRYPTION.equals(ctx.getProperty("org.globus.security.secMsg.msg.type"));
            }
            case 1: {
                return Constants.SIGNATURE.equals(ctx.getProperty("org.globus.security.secMsg.msg.type"));
            }
            case 2: {
                return Constants.ENCRYPTION.equals(ctx.getProperty("org.globus.security.secMsg.msg.type"));
            }
        }
        return false;
    }

    public String getName() {
        switch (this.type) {
            case 0: {
                return i18n.getMessage("gsiSecMsgMethod");
            }
            case 1: {
                return i18n.getMessage("gsiSecMsgMethodSig");
            }
            case 2: {
                return i18n.getMessage("gsiSecMsgMethodEnc");
            }
        }
        return "GSI secure message";
    }

    public int getProtectionType() {
        return this.type;
    }
}

