/*
 * Decompiled with CFR 0.152.
 */
package org.globus.usage.packets;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.usage.packets.CustomByteBuffer;
import org.globus.usage.packets.UsageMonitorPacket;

public class IPTimeMonitorPacket
extends UsageMonitorPacket {
    private static Log log = LogFactory.getLog((String)(class$org$globus$usage$packets$IPTimeMonitorPacket == null ? (class$org$globus$usage$packets$IPTimeMonitorPacket = IPTimeMonitorPacket.class$("org.globus.usage.packets.IPTimeMonitorPacket")) : class$org$globus$usage$packets$IPTimeMonitorPacket).getName());
    private static final byte[] UNKNOWN_SENDER = new byte[]{0, 0, 0, 0};
    protected long timeSent;
    protected InetAddress senderAddress;
    static /* synthetic */ Class class$org$globus$usage$packets$IPTimeMonitorPacket;

    public void setDateTime(Date d) {
        this.timeSent = d.getTime();
    }

    public Date getDateTime() {
        return new Date(this.timeSent);
    }

    public long getTimestamp() {
        return this.timeSent;
    }

    public void setTimestamp(long time) {
        this.timeSent = time;
    }

    public void setHostIP(InetAddress addr) {
        this.senderAddress = addr;
    }

    public InetAddress getHostIP() {
        return this.senderAddress;
    }

    public void packCustomFields(CustomByteBuffer buf) {
        byte[] addressByteArray;
        super.packCustomFields(buf);
        buf.putLong(this.timeSent);
        byte[] byArray = addressByteArray = this.senderAddress == null ? UNKNOWN_SENDER : this.senderAddress.getAddress();
        if (addressByteArray.length == 4) {
            log.debug((Object)"This outgoing packet is IPv4.");
            buf.put((byte)4);
        } else if (addressByteArray.length == 16) {
            log.debug((Object)"This outgoing packet is IPv6.");
            buf.put((byte)6);
        }
        buf.put(addressByteArray);
    }

    public void unpackCustomFields(CustomByteBuffer buf) {
        super.unpackCustomFields(buf);
        this.timeSent = buf.getLong();
        byte ipVersion = buf.get();
        byte[] addressByteArray = null;
        if (ipVersion == 4) {
            addressByteArray = new byte[4];
            buf.get(addressByteArray);
        } else if (ipVersion == 6) {
            addressByteArray = new byte[16];
            buf.get(addressByteArray);
        }
        if (addressByteArray == null) {
            log.error((Object)"IP version code neither 4 nor 6; can't proceed");
            this.senderAddress = null;
        } else {
            try {
                this.senderAddress = InetAddress.getByAddress(addressByteArray);
            }
            catch (UnknownHostException uhe) {
                log.error((Object)"This packet came from a host I can't identify");
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append(", sent at: " + this.getDateTime());
        buf.append(", from: " + this.getHostIP());
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

