/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.resources.runtime;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AccessPoint {
    private String endpoint;
    private String entryname;
    private String username;
    private String password;
    private String description;
    private Map<String, PropertyData> properties = new HashMap<String, PropertyData>();

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void addProperty(String name, String value, boolean ... encrypted) {
        this.properties.put(name, new PropertyData(value, encrypted != null && encrypted.length > 0 ? encrypted[0] : false));
    }

    public String getProperty(String name) {
        try {
            return this.properties.get(name).getValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isPropertyEncrypted(String name) {
        return this.properties.get(name).isEncrypted();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Set<String> getAllPropertyNames() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public String getEntryname() {
        return this.entryname;
    }

    public void setEntryname(String entryname) {
        this.entryname = entryname;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public class PropertyData {
        private final String value;
        private final boolean encrypted;

        public PropertyData(String value, boolean encrypted) {
            this.value = value;
            this.encrypted = encrypted;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isEncrypted() {
            return this.encrypted;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof PropertyData)) {
                return false;
            }
            PropertyData pairo = (PropertyData)o;
            return this.value.equals(pairo.getValue());
        }
    }
}

