/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.components.net.CommonsHTTPClientProperties;
import org.apache.axis.components.net.CommonsHTTPClientPropertiesFactory;
import org.apache.axis.components.net.TransportClientProperties;
import org.apache.axis.components.net.TransportClientPropertiesFactory;
import org.apache.axis.encoding.Base64;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.Messages;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.logging.Log;

public class CommonsHTTPSender
extends BasicHandler {
    protected static Log log = LogFactory.getLog((class$org$apache$axis$transport$http$CommonsHTTPSender == null ? (class$org$apache$axis$transport$http$CommonsHTTPSender = CommonsHTTPSender.class$("org.apache.axis.transport.http.CommonsHTTPSender")) : class$org$apache$axis$transport$http$CommonsHTTPSender).getName());
    protected HttpConnectionManager connectionManager;
    protected CommonsHTTPClientProperties clientProperties;
    static /* synthetic */ Class class$org$apache$axis$transport$http$CommonsHTTPSender;

    public CommonsHTTPSender() {
        this.initialize();
    }

    protected void initialize() {
        MultiThreadedHttpConnectionManager cm = new MultiThreadedHttpConnectionManager();
        this.clientProperties = CommonsHTTPClientPropertiesFactory.create();
        cm.setMaxConnectionsPerHost(this.clientProperties.getMaximumConnectionsPerHost());
        cm.setMaxTotalConnections(this.clientProperties.getMaximumTotalConnections());
        this.connectionManager = cm;
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        GetMethod method = null;
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("enter00", "CommonsHTTPSender::invoke"));
        }
        try {
            String webMethod;
            URL targetURL = new URL(msgContext.getStrProp("transport.url"));
            HttpClient httpClient = new HttpClient(this.connectionManager);
            httpClient.setHttpConnectionFactoryTimeout((long)this.clientProperties.getConnectionPoolTimeout());
            HostConfiguration hostConfiguration = this.getHostConfiguration(httpClient, msgContext, targetURL);
            boolean posting = true;
            if (msgContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS && (webMethod = msgContext.getStrProp("soap12.webmethod")) != null) {
                posting = webMethod.equals("POST");
            }
            if (posting) {
                Message reqMessage = msgContext.getRequestMessage();
                method = new PostMethod(targetURL.toString());
                method.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                this.addContextInfo((HttpMethodBase)method, httpClient, msgContext, targetURL);
                ((PostMethod)method).setRequestEntity((RequestEntity)new MessageRequestEntity((HttpMethodBase)method, reqMessage));
            } else {
                method = new GetMethod(targetURL.toString());
                this.addContextInfo((HttpMethodBase)method, httpClient, msgContext, targetURL);
            }
            String httpVersion = msgContext.getStrProp("axis.transport.version");
            if (httpVersion != null && httpVersion.equals(HTTPConstants.HEADER_PROTOCOL_V10)) {
                method.getParams().setVersion(HttpVersion.HTTP_1_0);
            }
            if (msgContext.getMaintainSession()) {
                String ck2;
                HttpState state = httpClient.getState();
                state.setCookiePolicy(0);
                String host = hostConfiguration.getHost();
                String path = targetURL.getPath();
                boolean secure = hostConfiguration.getProtocol().isSecure();
                String ck1 = (String)msgContext.getProperty("Cookie");
                if (ck1 != null) {
                    int index = ck1.indexOf(61);
                    state.addCookie(new Cookie(host, ck1.substring(0, index), ck1.substring(index + 1), path, null, secure));
                }
                if ((ck2 = (String)msgContext.getProperty("Cookie2")) != null) {
                    int index = ck2.indexOf(61);
                    state.addCookie(new Cookie(host, ck2.substring(0, index), ck2.substring(index + 1), path, null, secure));
                }
                httpClient.setState(state);
            }
            int returnCode = httpClient.executeMethod(hostConfiguration, (HttpMethod)method, null);
            String contentType = CommonsHTTPSender.getHeader((HttpMethodBase)method, "Content-Type");
            String contentLocation = CommonsHTTPSender.getHeader((HttpMethodBase)method, "Content-Location");
            String contentLength = CommonsHTTPSender.getHeader((HttpMethodBase)method, "Content-Length");
            if (!(returnCode > 199 && returnCode < 300 || msgContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS || contentType != null && !contentType.equals("text/html") && returnCode > 499 && returnCode < 600)) {
                String statusMessage = method.getStatusText();
                AxisFault fault = new AxisFault("HTTP", "(" + returnCode + ")" + statusMessage, null, null);
                try {
                    fault.setFaultDetailString(Messages.getMessage("return01", "" + returnCode, method.getResponseBodyAsString()));
                    fault.addFaultDetail(Constants.QNAME_FAULTDETAIL_HTTPERRORCODE, Integer.toString(returnCode));
                    throw fault;
                }
                catch (Throwable throwable) {
                    method.releaseConnection();
                    throw throwable;
                }
            }
            if (msgContext.isPropertyTrue("axis.one.way")) {
                method.releaseConnection();
                return;
            }
            InputStream releaseConnectionOnCloseStream = this.createConnectionReleasingInputStream((HttpMethodBase)method);
            Message outMsg = new Message(releaseConnectionOnCloseStream, false, contentType, contentLocation);
            Header[] responseHeaders = method.getResponseHeaders();
            MimeHeaders responseMimeHeaders = outMsg.getMimeHeaders();
            for (int i = 0; i < responseHeaders.length; ++i) {
                Header responseHeader = responseHeaders[i];
                responseMimeHeaders.addHeader(responseHeader.getName(), responseHeader.getValue());
            }
            outMsg.setMessageType("response");
            msgContext.setResponseMessage(outMsg);
            if (log.isDebugEnabled()) {
                if (null == contentLength) {
                    log.debug("\n" + Messages.getMessage("no00", "Content-Length"));
                }
                log.debug("\n" + Messages.getMessage("xmlRecd00"));
                log.debug("-----------------------------------------------");
                log.debug(outMsg.getSOAPPartAsString());
            }
            if (msgContext.getMaintainSession()) {
                Header[] headers = method.getResponseHeaders();
                for (int i = 0; i < headers.length; ++i) {
                    if (headers[i].getName().equalsIgnoreCase("Set-Cookie")) {
                        msgContext.setProperty("Cookie", this.cleanupCookie(headers[i].getValue()));
                        continue;
                    }
                    if (!headers[i].getName().equalsIgnoreCase("Set-Cookie2")) continue;
                    msgContext.setProperty("Cookie2", this.cleanupCookie(headers[i].getValue()));
                }
            }
        }
        catch (Exception e) {
            log.debug(e);
            throw AxisFault.makeFault(e);
        }
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("exit00", "CommonsHTTPSender::invoke"));
        }
    }

    private String cleanupCookie(String cookie) {
        int index = (cookie = cookie.trim()).indexOf(59);
        if (index != -1) {
            cookie = cookie.substring(0, index);
        }
        return cookie;
    }

    protected HostConfiguration getHostConfiguration(HttpClient client, MessageContext context, URL targetURL) {
        TransportClientProperties tcp = TransportClientPropertiesFactory.create(targetURL.getProtocol());
        int port = targetURL.getPort();
        boolean hostInNonProxyList = this.isHostInNonProxyList(targetURL.getHost(), tcp.getNonProxyHosts());
        HostConfiguration config = new HostConfiguration();
        if (port == -1) {
            port = 80;
        }
        if (hostInNonProxyList) {
            config.setHost(targetURL.getHost(), port, targetURL.getProtocol());
        } else if (tcp.getProxyHost().length() == 0 || tcp.getProxyPort().length() == 0) {
            config.setHost(targetURL.getHost(), port, targetURL.getProtocol());
        } else {
            if (tcp.getProxyUser().length() != 0) {
                UsernamePasswordCredentials proxyCred = new UsernamePasswordCredentials(tcp.getProxyUser(), tcp.getProxyPassword());
                int domainIndex = tcp.getProxyUser().indexOf("\\");
                if (domainIndex > 0) {
                    String domain = tcp.getProxyUser().substring(0, domainIndex);
                    if (tcp.getProxyUser().length() > domainIndex + 1) {
                        String user = tcp.getProxyUser().substring(domainIndex + 1);
                        proxyCred = new NTCredentials(user, tcp.getProxyPassword(), tcp.getProxyHost(), domain);
                    }
                }
                client.getState().setProxyCredentials(null, null, (Credentials)proxyCred);
            }
            int proxyPort = new Integer(tcp.getProxyPort());
            config.setProxy(tcp.getProxyHost(), proxyPort);
        }
        return config;
    }

    private void addContextInfo(HttpMethodBase method, HttpClient httpClient, MessageContext msgContext, URL tmpURL) throws Exception {
        Hashtable userHeaderTable;
        MimeHeaders mimeHeaders;
        Message msg;
        String action;
        if (msgContext.getTimeout() != 0) {
            httpClient.setTimeout(msgContext.getTimeout());
            httpClient.setConnectionTimeout(msgContext.getTimeout());
        }
        String string = action = msgContext.useSOAPAction() ? msgContext.getSOAPActionURI() : "";
        if (action == null) {
            action = "";
        }
        if ((msg = msgContext.getRequestMessage()) != null) {
            method.setRequestHeader(new Header("Content-Type", msg.getContentType(msgContext.getSOAPConstants())));
        }
        method.setRequestHeader(new Header("SOAPAction", "\"" + action + "\""));
        String userID = msgContext.getUsername();
        String passwd = msgContext.getPassword();
        if (userID == null && tmpURL.getUserInfo() != null) {
            String info = tmpURL.getUserInfo();
            int sep = info.indexOf(58);
            if (sep >= 0 && sep + 1 < info.length()) {
                userID = info.substring(0, sep);
                passwd = info.substring(sep + 1);
            } else {
                userID = info;
            }
        }
        if (userID != null) {
            UsernamePasswordCredentials cred = new UsernamePasswordCredentials(userID, passwd);
            httpClient.getState().setCredentials(null, null, (Credentials)cred);
            StringBuffer tmpBuf = new StringBuffer();
            tmpBuf.append(userID).append(":").append(passwd == null ? "" : passwd);
            method.addRequestHeader("Authorization", "Basic " + Base64.encode(tmpBuf.toString().getBytes()));
        }
        if ((mimeHeaders = msg.getMimeHeaders()) != null) {
            Iterator i = mimeHeaders.getAllHeaders();
            while (i.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)i.next();
                method.addRequestHeader(mimeHeader.getName(), mimeHeader.getValue());
            }
        }
        if ((userHeaderTable = (Hashtable)msgContext.getProperty("HTTP-Request-Headers")) != null) {
            Iterator e = userHeaderTable.entrySet().iterator();
            while (e.hasNext()) {
                Map.Entry me = e.next();
                Object keyObj = me.getKey();
                if (null == keyObj) continue;
                String key = keyObj.toString().trim();
                String value = me.getValue().toString().trim();
                if (key.equalsIgnoreCase("Expect") && value.equalsIgnoreCase("100-continue")) {
                    method.getParams().setBooleanParameter("http.protocol.expect-continue", true);
                    continue;
                }
                method.addRequestHeader(key, value);
            }
        }
    }

    protected boolean isHostInNonProxyList(String host, String nonProxyHosts) {
        if (nonProxyHosts == null || host == null) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(nonProxyHosts, "|\"");
        while (tokenizer.hasMoreTokens()) {
            String pattern = tokenizer.nextToken();
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("match00", new String[]{"HTTPSender", host, pattern}));
            }
            if (!CommonsHTTPSender.match(pattern, host, false)) continue;
            return true;
        }
        return false;
    }

    protected static boolean match(String pattern, String str, boolean isCaseSensitive) {
        char ch;
        int i;
        char[] patArr = pattern.toCharArray();
        char[] strArr = str.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (i = 0; i < patArr.length; ++i) {
            if (patArr[i] != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (i = 0; i <= patIdxEnd; ++i) {
                char ch2 = patArr[i];
                if (isCaseSensitive && ch2 != strArr[i]) {
                    return false;
                }
                if (isCaseSensitive || Character.toUpperCase(ch2) == Character.toUpperCase(strArr[i])) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (isCaseSensitive && ch != strArr[strIdxStart]) {
                return false;
            }
            if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart])) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (isCaseSensitive && ch != strArr[strIdxEnd]) {
                return false;
            }
            if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxEnd])) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i2 = patIdxStart + 1; i2 <= patIdxEnd; ++i2) {
                if (patArr[i2] != '*') continue;
                patIdxTmp = i2;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i3 = 0; i3 <= strLength - patLength; ++i3) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (isCaseSensitive && ch != strArr[strIdxStart + i3 + j] || !isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart + i3 + j])) continue block8;
                }
                foundIdx = strIdxStart + i3;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (i = patIdxStart; i <= patIdxEnd; ++i) {
            if (patArr[i] == '*') continue;
            return false;
        }
        return true;
    }

    private static String getHeader(HttpMethodBase method, String headerName) {
        Header header = method.getResponseHeader(headerName);
        return header == null ? null : header.getValue().trim();
    }

    private InputStream createConnectionReleasingInputStream(final HttpMethodBase method) throws IOException {
        return new FilterInputStream(method.getResponseBodyAsStream()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    method.releaseConnection();
                }
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MessageRequestEntity
    implements RequestEntity {
        private HttpMethodBase method;
        private Message message;

        public MessageRequestEntity(HttpMethodBase method, Message message) {
            this.message = message;
            this.method = method;
        }

        public boolean isRepeatable() {
            return true;
        }

        public void writeRequest(OutputStream out) throws IOException {
            try {
                this.message.writeTo(out);
            }
            catch (SOAPException e) {
                throw new IOException(e.getMessage());
            }
        }

        public long getContentLength() {
            if (this.method.getParams().getVersion() == HttpVersion.HTTP_1_0 || this.method.getParams().isParameterTrue("transport.http.disableChunking")) {
                try {
                    return this.message.getContentLength();
                }
                catch (Exception e) {
                    return -1L;
                }
            }
            return -1L;
        }

        public String getContentType() {
            return null;
        }
    }
}

